/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.trace;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.semconv.SemanticAttributes;
import java.util.List;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class HBaseSemanticAttributes {
    public static final AttributeKey<String> DB_SYSTEM = SemanticAttributes.DB_SYSTEM;
    public static final String DB_SYSTEM_VALUE = "hbase";
    public static final AttributeKey<String> DB_CONNECTION_STRING = SemanticAttributes.DB_CONNECTION_STRING;
    public static final AttributeKey<String> DB_USER = SemanticAttributes.DB_USER;
    public static final AttributeKey<String> DB_NAME = SemanticAttributes.DB_NAME;
    public static final AttributeKey<String> DB_OPERATION = SemanticAttributes.DB_OPERATION;
    public static final AttributeKey<String> TABLE_KEY = AttributeKey.stringKey((String)"db.hbase.table");
    public static final AttributeKey<List<String>> CONTAINER_DB_OPERATIONS_KEY = AttributeKey.stringArrayKey((String)"db.hbase.container_operations");
    public static final AttributeKey<List<String>> REGION_NAMES_KEY = AttributeKey.stringArrayKey((String)"db.hbase.regions");
    public static final AttributeKey<String> RPC_SYSTEM = SemanticAttributes.RPC_SYSTEM;
    public static final AttributeKey<String> RPC_SERVICE = SemanticAttributes.RPC_SERVICE;
    public static final AttributeKey<String> RPC_METHOD = SemanticAttributes.RPC_METHOD;
    public static final AttributeKey<String> SERVER_NAME_KEY = AttributeKey.stringKey((String)"db.hbase.server.name");
    public static final AttributeKey<String> NET_PEER_NAME = SemanticAttributes.NET_PEER_NAME;
    public static final AttributeKey<Long> NET_PEER_PORT = SemanticAttributes.NET_PEER_PORT;
    public static final AttributeKey<Boolean> ROW_LOCK_READ_LOCK_KEY = AttributeKey.booleanKey((String)"db.hbase.rowlock.readlock");
    public static final AttributeKey<String> WAL_IMPL = AttributeKey.stringKey((String)"db.hbase.wal.impl");
    public static final AttributeKey<String> EXCEPTION_TYPE = SemanticAttributes.EXCEPTION_TYPE;
    public static final AttributeKey<String> EXCEPTION_MESSAGE = SemanticAttributes.EXCEPTION_MESSAGE;
    public static final String EXCEPTION_EVENT_NAME = "exception";
    public static final AttributeKey<Long> DIRECT_BYTES_READ_KEY = AttributeKey.longKey((String)"db.hbase.io.direct_bytes_read");
    public static final AttributeKey<Long> HEAP_BYTES_READ_KEY = AttributeKey.longKey((String)"db.hbase.io.heap_bytes_read");
    public static final AttributeKey<String> COMPRESSION_ALGORITHM_KEY = AttributeKey.stringKey((String)"db.hbase.io.hfile.data_block_encoding");
    public static final AttributeKey<String> DATA_BLOCK_ENCODING_KEY = AttributeKey.stringKey((String)"db.hbase.io.hfile.data_block_encoding");
    public static final AttributeKey<String> ENCRYPTION_CIPHER_KEY = AttributeKey.stringKey((String)"db.hbase.io.hfile.encryption_cipher");
    public static final AttributeKey<String> CHECKSUM_KEY = AttributeKey.stringKey((String)"db.hbase.io.hfile.checksum_type");
    public static final AttributeKey<String> HFILE_NAME_KEY = AttributeKey.stringKey((String)"db.hbase.io.hfile.file_name");
    public static final AttributeKey<String> READ_TYPE_KEY = AttributeKey.stringKey((String)"db.hbase.io.hfile.read_type");
    public static final AttributeKey<String> BLOCK_CACHE_KEY_KEY = AttributeKey.stringKey((String)"db.hbase.io.hfile.block_cache_key");

    private HBaseSemanticAttributes() {
    }

    public static enum RpcSystem {
        HBASE_RPC;

    }

    public static enum Operation {
        APPEND,
        BATCH,
        CHECK_AND_MUTATE,
        COPROC_EXEC,
        DELETE,
        GET,
        INCREMENT,
        PUT,
        SCAN;

    }

    public static enum ReadType {
        POSITIONAL_READ,
        SEEK_PLUS_READ;

    }
}

