/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions.python;

import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.python.PythonEnv;
import org.apache.flink.table.functions.python.PythonFunction;
import org.apache.flink.table.functions.python.PythonFunctionKind;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
public class PythonAggregateFunction
extends AggregateFunction
implements PythonFunction {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final byte[] serializedAggregateFunction;
    private final PythonFunctionKind pythonFunctionKind;
    private final boolean deterministic;
    private final PythonEnv pythonEnv;
    private final boolean takesRowAsInput;
    private DataType[] inputTypes;
    private String[] inputTypesString;
    private DataType resultType;
    private String resultTypeString;
    private DataType accumulatorType;
    private String accumulatorTypeString;

    public PythonAggregateFunction(String name, byte[] serializedAggregateFunction, DataType[] inputTypes, DataType resultType, DataType accumulatorType, PythonFunctionKind pythonFunctionKind, boolean deterministic, boolean takesRowAsInput, PythonEnv pythonEnv) {
        this(name, serializedAggregateFunction, pythonFunctionKind, deterministic, takesRowAsInput, pythonEnv);
        this.inputTypes = inputTypes;
        this.resultType = resultType;
        this.accumulatorType = accumulatorType;
    }

    public PythonAggregateFunction(String name, byte[] serializedAggregateFunction, String[] inputTypesString, String resultTypeString, String accumulatorTypeString, PythonFunctionKind pythonFunctionKind, boolean deterministic, boolean takesRowAsInput, PythonEnv pythonEnv) {
        this(name, serializedAggregateFunction, pythonFunctionKind, deterministic, takesRowAsInput, pythonEnv);
        this.inputTypesString = inputTypesString;
        this.resultTypeString = resultTypeString;
        this.accumulatorTypeString = accumulatorTypeString;
    }

    public PythonAggregateFunction(String name, byte[] serializedAggregateFunction, PythonFunctionKind pythonFunctionKind, boolean deterministic, boolean takesRowAsInput, PythonEnv pythonEnv) {
        this.name = name;
        this.serializedAggregateFunction = serializedAggregateFunction;
        this.pythonFunctionKind = pythonFunctionKind;
        this.deterministic = deterministic;
        this.pythonEnv = pythonEnv;
        this.takesRowAsInput = takesRowAsInput;
    }

    public void accumulate(Object accumulator, Object ... args) {
        throw new UnsupportedOperationException("This method is a placeholder and should not be called.");
    }

    public Object getValue(Object accumulator) {
        return null;
    }

    @Override
    public Object createAccumulator() {
        return null;
    }

    @Override
    public byte[] getSerializedPythonFunction() {
        return this.serializedAggregateFunction;
    }

    @Override
    public PythonEnv getPythonEnv() {
        return this.pythonEnv;
    }

    @Override
    public PythonFunctionKind getPythonFunctionKind() {
        return this.pythonFunctionKind;
    }

    @Override
    public boolean takesRowAsInput() {
        return this.takesRowAsInput;
    }

    @Override
    public boolean isDeterministic() {
        return this.deterministic;
    }

    @Override
    public TypeInformation getResultType() {
        if (this.resultType == null && this.resultTypeString != null) {
            throw new RuntimeException("String format result type is not supported in old type system.");
        }
        return TypeConversions.fromDataTypeToLegacyInfo(this.resultType);
    }

    @Override
    public TypeInformation getAccumulatorType() {
        if (this.accumulatorType == null && this.accumulatorTypeString != null) {
            throw new RuntimeException("String format accumulator type is not supported in old type system.");
        }
        return TypeConversions.fromDataTypeToLegacyInfo(this.accumulatorType);
    }

    @Override
    public TypeInference getTypeInference(DataTypeFactory typeFactory) {
        TypeInference.Builder builder = TypeInference.newBuilder();
        if (this.inputTypesString != null) {
            this.inputTypes = (DataType[])Arrays.stream(this.inputTypesString).map(typeFactory::createDataType).toArray(DataType[]::new);
        }
        if (this.inputTypes != null) {
            builder.typedArguments(this.inputTypes);
        }
        if (this.resultType == null) {
            this.resultType = typeFactory.createDataType(this.resultTypeString);
        }
        if (this.accumulatorType == null) {
            this.accumulatorType = typeFactory.createDataType(this.accumulatorTypeString);
        }
        return builder.outputTypeStrategy(TypeStrategies.explicit(this.resultType)).accumulatorTypeStrategy(TypeStrategies.explicit(this.accumulatorType)).build();
    }

    @Override
    public String toString() {
        return this.name;
    }
}

