/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.internal;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.table.api.ResultKind;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.internal.CachedPlan;
import org.apache.flink.table.api.internal.ResultProvider;
import org.apache.flink.table.api.internal.StaticResultProvider;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.utils.print.PrintStyle;
import org.apache.flink.table.utils.print.RowDataToStringConverter;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.Preconditions;

@Internal
public class TableResultImpl
implements TableResultInternal {
    private final JobClient jobClient;
    private final ResolvedSchema resolvedSchema;
    private final ResultKind resultKind;
    private final ResultProvider resultProvider;
    private final PrintStyle printStyle;
    private final CachedPlan cachedPlan;

    private TableResultImpl(@Nullable JobClient jobClient, ResolvedSchema resolvedSchema, ResultKind resultKind, ResultProvider resultProvider, PrintStyle printStyle, CachedPlan cachedPlan) {
        this.jobClient = jobClient;
        this.resolvedSchema = (ResolvedSchema)Preconditions.checkNotNull((Object)resolvedSchema, (String)"resolvedSchema should not be null");
        this.resultKind = (ResultKind)((Object)Preconditions.checkNotNull((Object)((Object)resultKind), (String)"resultKind should not be null"));
        Preconditions.checkNotNull((Object)resultProvider, (String)"result provider should not be null");
        this.resultProvider = resultProvider;
        this.printStyle = (PrintStyle)Preconditions.checkNotNull((Object)printStyle, (String)"printStyle should not be null");
        this.cachedPlan = cachedPlan;
    }

    @Override
    public Optional<JobClient> getJobClient() {
        return Optional.ofNullable(this.jobClient);
    }

    @Override
    public void await() throws InterruptedException, ExecutionException {
        try {
            this.awaitInternal(-1L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    @Override
    public void await(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.awaitInternal(timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitInternal(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.jobClient == null) {
            return;
        }
        ExecutorService executor = Executors.newFixedThreadPool(1, r -> new Thread(r, "TableResult-await-thread"));
        try {
            CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                while (!this.resultProvider.isFirstRowReady()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        throw new TableException("Thread is interrupted");
                    }
                }
            }, executor);
            if (timeout >= 0L) {
                future.get(timeout, unit);
            } else {
                future.get();
            }
        }
        finally {
            executor.shutdown();
        }
    }

    @Override
    public ResolvedSchema getResolvedSchema() {
        return this.resolvedSchema;
    }

    @Override
    public ResultKind getResultKind() {
        return this.resultKind;
    }

    @Override
    public CloseableIterator<Row> collect() {
        return this.resultProvider.toExternalIterator();
    }

    @Override
    public CloseableIterator<RowData> collectInternal() {
        return this.resultProvider.toInternalIterator();
    }

    @Override
    public RowDataToStringConverter getRowDataToStringConverter() {
        return this.resultProvider.getRowDataStringConverter();
    }

    @Override
    @Nullable
    public CachedPlan getCachedPlan() {
        return this.cachedPlan;
    }

    @Override
    public void print() {
        CloseableIterator<RowData> it = this.resultProvider.toInternalIterator();
        this.printStyle.print((Iterator<RowData>)it, new PrintWriter(System.out));
    }

    public PrintStyle getPrintStyle() {
        return this.printStyle;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Internal
    public static class Builder {
        private JobClient jobClient = null;
        private ResolvedSchema resolvedSchema = null;
        private ResultKind resultKind = null;
        private ResultProvider resultProvider = null;
        private PrintStyle printStyle = null;
        private CachedPlan cachedPlan = null;

        private Builder() {
        }

        public Builder jobClient(JobClient jobClient) {
            this.jobClient = jobClient;
            return this;
        }

        public Builder schema(ResolvedSchema resolvedSchema) {
            Preconditions.checkNotNull((Object)resolvedSchema, (String)"resolvedSchema should not be null");
            this.resolvedSchema = resolvedSchema;
            return this;
        }

        public Builder resultKind(ResultKind resultKind) {
            Preconditions.checkNotNull((Object)((Object)resultKind), (String)"resultKind should not be null");
            this.resultKind = resultKind;
            return this;
        }

        public Builder resultProvider(ResultProvider resultProvider) {
            Preconditions.checkNotNull((Object)resultProvider, (String)"resultProvider should not be null");
            this.resultProvider = resultProvider;
            return this;
        }

        public Builder data(List<Row> rowList) {
            Preconditions.checkNotNull(rowList, (String)"listRows should not be null");
            this.resultProvider = new StaticResultProvider(rowList);
            return this;
        }

        public Builder setPrintStyle(PrintStyle printStyle) {
            Preconditions.checkNotNull((Object)printStyle, (String)"printStyle should not be null");
            this.printStyle = printStyle;
            return this;
        }

        public Builder setCachedPlan(CachedPlan cachedPlan) {
            this.cachedPlan = cachedPlan;
            return this;
        }

        public TableResultInternal build() {
            if (this.printStyle == null) {
                this.printStyle = PrintStyle.rawContent(this.resultProvider.getRowDataStringConverter());
            }
            return new TableResultImpl(this.jobClient, this.resolvedSchema, this.resultKind, this.resultProvider, this.printStyle, this.cachedPlan);
        }
    }
}

