/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.connector.source;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.VectorSearchTableSource;
import org.apache.flink.table.data.conversion.DataStructureConverters;
import org.apache.flink.table.runtime.connector.source.DataStructureConverterWrapper;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.DataTypeUtils;

public class VectorSearchRuntimeProviderContext
implements VectorSearchTableSource.VectorSearchContext {
    private final int[][] searchColumns;
    private final ReadableConfig runtimeConfig;

    public VectorSearchRuntimeProviderContext(int[][] searchColumns, ReadableConfig runtimeConfig) {
        this.searchColumns = searchColumns;
        this.runtimeConfig = runtimeConfig;
    }

    public int[][] getSearchColumns() {
        return this.searchColumns;
    }

    public ReadableConfig runtimeConfig() {
        return this.runtimeConfig;
    }

    public <T> TypeInformation<T> createTypeInformation(DataType producedDataType) {
        DataTypeUtils.validateInputDataType((DataType)producedDataType);
        return InternalTypeInfo.of(producedDataType.getLogicalType());
    }

    public <T> TypeInformation<T> createTypeInformation(LogicalType producedLogicalType) {
        return InternalTypeInfo.of(producedLogicalType);
    }

    public DynamicTableSource.DataStructureConverter createDataStructureConverter(DataType producedDataType) {
        DataTypeUtils.validateInputDataType((DataType)producedDataType);
        return new DataStructureConverterWrapper(DataStructureConverters.getConverter(producedDataType));
    }
}

