/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
public class ArrayAppendPrependTypeStrategy
implements TypeStrategy {
    @Override
    public Optional<DataType> inferType(CallContext callContext) {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        DataType arrayDataType = argumentDataTypes.get(0);
        DataType elementToAddDataType = argumentDataTypes.get(1);
        LogicalType arrayElementLogicalType = arrayDataType.getLogicalType().getChildren().get(0);
        if (elementToAddDataType.getLogicalType().isNullable() && !arrayElementLogicalType.isNullable()) {
            return Optional.of(DataTypes.ARRAY((DataType)TypeConversions.fromLogicalToDataType(arrayElementLogicalType).nullable()));
        }
        return Optional.of(arrayDataType);
    }
}

