/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.csv.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.plan.stats.TableStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvFormatStatisticsReportUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CsvFormatStatisticsReportUtil.class);

    public static TableStats getTableStatistics(List<Path> files) {
        int totalSampleLineCnt = 100;
        try {
            long totalFileSize = 0L;
            int sampledRowCnt = 0;
            long sampledRowSize = 0L;
            for (Path file : files) {
                FileSystem fs = FileSystem.get((URI)file.toUri());
                FileStatus status = fs.getFileStatus(file);
                totalFileSize += status.getLen();
                if (sampledRowCnt >= 100) continue;
                try (InputStreamReader isr = new InputStreamReader(Files.newInputStream(new File(file.toUri()).toPath(), new OpenOption[0]));
                     BufferedReader br = new BufferedReader(isr);){
                    String line;
                    while (sampledRowCnt < 100 && (line = br.readLine()) != null) {
                        ++sampledRowCnt;
                        sampledRowSize += (long)(line.getBytes(StandardCharsets.UTF_8).length + 1);
                    }
                }
            }
            if (sampledRowCnt < 100) {
                sampledRowSize = totalFileSize;
            }
            if (sampledRowSize == 0L) {
                return TableStats.UNKNOWN;
            }
            int realSampledLineCnt = Math.min(100, sampledRowCnt);
            long estimatedRowCount = totalFileSize * (long)realSampledLineCnt / sampledRowSize;
            return new TableStats(estimatedRowCount);
        }
        catch (Exception e) {
            LOG.warn("Reporting statistics failed for Csv format: {}", (Object)e.getMessage());
            return TableStats.UNKNOWN;
        }
    }
}

