/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.file.table.MetastoreCommitPolicy;
import org.apache.flink.connector.file.table.PartitionCommitPolicy;
import org.apache.flink.connector.file.table.TableMetaStoreFactory;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.utils.PartitionPathUtils;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.Preconditions;

@Internal
public class PartitionLoader
implements Closeable {
    private final boolean overwrite;
    private final FileSystem fs;
    private final TableMetaStoreFactory.TableMetaStore metaStore;
    private final boolean isToLocal;
    private final ObjectIdentifier identifier;
    private final List<PartitionCommitPolicy> policies;

    public PartitionLoader(boolean overwrite, FileSystem sourceFs, TableMetaStoreFactory factory, boolean isToLocal, ObjectIdentifier identifier, List<PartitionCommitPolicy> policies) throws Exception {
        this.overwrite = overwrite;
        this.fs = sourceFs;
        this.metaStore = factory.createTableMetaStore();
        this.isToLocal = isToLocal;
        this.identifier = identifier;
        this.policies = policies;
    }

    public void loadPartition(LinkedHashMap<String, String> partSpec, List<Path> srcPaths, boolean srcPathIsDir) throws Exception {
        Optional<Path> pathFromMeta = this.metaStore.getPartition(partSpec);
        Path path = pathFromMeta.orElseGet(() -> new Path(this.metaStore.getLocationPath(), PartitionPathUtils.generatePartitionPath((LinkedHashMap)partSpec)));
        this.overwriteAndMoveFiles(srcPaths, path, srcPathIsDir);
        this.commitPartition(partSpec, path);
    }

    public void loadNonPartition(List<Path> srcPaths, boolean srcPathIsDir) throws Exception {
        Path tableLocation = this.metaStore.getLocationPath();
        this.overwriteAndMoveFiles(srcPaths, tableLocation, srcPathIsDir);
        this.commitPartition(new LinkedHashMap<String, String>(), tableLocation);
        this.metaStore.finishWritingTable(tableLocation);
    }

    public void loadEmptyPartition(LinkedHashMap<String, String> partSpec) throws Exception {
        Optional<Path> pathFromMeta = this.metaStore.getPartition(partSpec);
        if (pathFromMeta.isPresent() && !this.overwrite) {
            this.commitPartition(partSpec, pathFromMeta.get());
            return;
        }
        Path path = new Path(this.metaStore.getLocationPath(), PartitionPathUtils.generatePartitionPath(partSpec));
        if (pathFromMeta.isPresent()) {
            this.fs.delete(pathFromMeta.get(), true);
            this.fs.mkdirs(path);
        }
        this.commitPartition(partSpec, path);
    }

    private void overwriteAndMoveFiles(List<Path> srcPaths, Path destDir, boolean srcPathIsDir) throws Exception {
        FileSystem destFileSystem = destDir.getFileSystem();
        boolean dirSuccessExist = destFileSystem.exists(destDir) || destFileSystem.mkdirs(destDir);
        Preconditions.checkState((boolean)dirSuccessExist, (Object)("Failed to create dest path " + destDir));
        this.overwrite(destDir);
        this.moveFiles(srcPaths, destDir, srcPathIsDir);
    }

    private void overwrite(Path destDir) throws Exception {
        FileSystem destFS;
        FileStatus[] existingFiles;
        if (this.overwrite && (existingFiles = PartitionPathUtils.listStatusWithoutHidden((FileSystem)(destFS = destDir.getFileSystem()), (Path)destDir)) != null) {
            for (FileStatus existingFile : existingFiles) {
                destFS.delete(existingFile.getPath(), true);
            }
        }
    }

    private void moveFiles(List<Path> srcPaths, Path destDir, boolean srcPathIsDir) throws Exception {
        if (srcPathIsDir) {
            for (Path srcDir : srcPaths) {
                FileStatus[] srcFiles;
                if (srcDir.equals((Object)destDir) || (srcFiles = PartitionPathUtils.listStatusWithoutHidden((FileSystem)this.fs, (Path)srcDir)) == null) continue;
                for (FileStatus srcFile : srcFiles) {
                    this.moveFile(srcFile.getPath(), destDir);
                }
            }
        } else {
            for (Path srcPath : srcPaths) {
                this.moveFile(srcPath, destDir);
            }
        }
    }

    private void moveFile(Path srcPath, Path destDir) throws Exception {
        Path destPath = new Path(destDir, srcPath.getName());
        if (!this.isToLocal) {
            this.fs.rename(srcPath, destPath);
        } else {
            FileUtils.copy((Path)srcPath, (Path)destPath, (boolean)true);
        }
    }

    private void commitPartition(LinkedHashMap<String, String> partitionSpec, Path path) throws Exception {
        CommitPolicyContextImpl context = new CommitPolicyContextImpl(partitionSpec, path);
        for (PartitionCommitPolicy policy : this.policies) {
            if (policy instanceof MetastoreCommitPolicy) {
                if (partitionSpec.isEmpty()) continue;
                ((MetastoreCommitPolicy)policy).setMetastore(this.metaStore);
            }
            policy.commit(context);
        }
    }

    @Override
    public void close() throws IOException {
        this.metaStore.close();
    }

    private class CommitPolicyContextImpl
    implements PartitionCommitPolicy.Context {
        private final Path partitionPath;
        private final LinkedHashMap<String, String> partitionSpec;

        private CommitPolicyContextImpl(LinkedHashMap<String, String> partitionSpec, Path partitionPath) {
            this.partitionSpec = partitionSpec;
            this.partitionPath = partitionPath;
        }

        @Override
        public String catalogName() {
            return PartitionLoader.this.identifier.getCatalogName();
        }

        @Override
        public String databaseName() {
            return PartitionLoader.this.identifier.getDatabaseName();
        }

        @Override
        public String tableName() {
            return PartitionLoader.this.identifier.getObjectName();
        }

        @Override
        public List<String> partitionKeys() {
            LinkedList<String> partitionKeys = new LinkedList<String>();
            for (Map.Entry<String, String> entry : this.partitionSpec.entrySet()) {
                partitionKeys.add(entry.getKey());
            }
            return partitionKeys;
        }

        @Override
        public List<String> partitionValues() {
            return new ArrayList<String>(this.partitionSpec.values());
        }

        @Override
        public Path partitionPath() {
            return this.partitionPath;
        }

        @Override
        public LinkedHashMap<String, String> partitionSpec() {
            return this.partitionSpec;
        }
    }
}

