/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.datadog;

import java.util.Properties;
import org.apache.flink.metrics.datadog.DataCenter;
import org.apache.flink.metrics.datadog.DatadogHttpReporter;
import org.apache.flink.metrics.reporter.MetricReporter;
import org.apache.flink.metrics.reporter.MetricReporterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatadogHttpReporterFactory
implements MetricReporterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DatadogHttpReporterFactory.class);
    private static final String API_KEY = "apikey";
    private static final String PROXY_HOST = "proxyHost";
    private static final String PROXY_PORT = "proxyPort";
    private static final String DATA_CENTER = "dataCenter";
    private static final String TAGS = "tags";
    private static final String MAX_METRICS_PER_REQUEST = "maxMetricsPerRequest";
    private static final String USE_LOGICAL_IDENTIFIER = "useLogicalIdentifier";

    public MetricReporter createMetricReporter(Properties config) {
        String apiKey = config.getProperty(API_KEY, null);
        String proxyHost = config.getProperty(PROXY_HOST, null);
        int proxyPort = Integer.valueOf(config.getProperty(PROXY_PORT, "8080"));
        String rawDataCenter = config.getProperty(DATA_CENTER, "US");
        int maxMetricsPerRequestValue = Integer.valueOf(config.getProperty(MAX_METRICS_PER_REQUEST, "2000"));
        DataCenter dataCenter = DataCenter.valueOf(rawDataCenter);
        if (config.containsKey(TAGS)) {
            LOG.warn("The 'tags' option is deprecated; please use 'scope.variables.additional' instead.");
        }
        String tags = config.getProperty(TAGS, "");
        boolean useLogicalIdentifier = Boolean.parseBoolean(config.getProperty(USE_LOGICAL_IDENTIFIER, "false"));
        return new DatadogHttpReporter(apiKey, proxyHost, proxyPort, maxMetricsPerRequestValue, dataCenter, tags, useLogicalIdentifier);
    }
}

