/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
class RoundTypeStrategy
implements TypeStrategy {
    RoundTypeStrategy() {
    }

    @Override
    public Optional<DataType> inferType(CallContext callContext) {
        BigDecimal roundLength;
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        DataType argumentDataType = callContext.getArgumentDataTypes().get(0);
        LogicalType argumentType = argumentDataType.getLogicalType();
        if (argumentType instanceof LegacyTypeInformationType) {
            return Optional.of(argumentDataType);
        }
        if (!argumentType.is(LogicalTypeRoot.DECIMAL)) {
            return Optional.of(argumentDataType);
        }
        if (argumentDataTypes.size() == 2) {
            if (!callContext.isArgumentLiteral(1) || callContext.isArgumentNull(1)) {
                return Optional.of(argumentDataType);
            }
            roundLength = callContext.getArgumentValue(1, BigDecimal.class).orElseThrow(AssertionError::new);
        } else {
            roundLength = BigDecimal.ZERO;
        }
        DecimalType inferredType = LogicalTypeMerging.findRoundDecimalType(LogicalTypeChecks.getPrecision(argumentType), LogicalTypeChecks.getScale(argumentType), roundLength.intValueExact());
        return Optional.of(TypeConversions.fromLogicalToDataType(inferredType));
    }
}

