/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.connector;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class ChangelogMode {
    private static final ChangelogMode INSERT_ONLY = ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).build();
    private static final ChangelogMode UPSERT = ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();
    private static final ChangelogMode ALL = ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_BEFORE).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();
    private final Set<RowKind> kinds;

    private ChangelogMode(Set<RowKind> kinds) {
        Preconditions.checkArgument((kinds.size() > 0 ? 1 : 0) != 0, (Object)"At least one kind of row should be contained in a changelog.");
        this.kinds = Collections.unmodifiableSet(kinds);
    }

    public static ChangelogMode insertOnly() {
        return INSERT_ONLY;
    }

    public static ChangelogMode upsert() {
        return UPSERT;
    }

    public static ChangelogMode all() {
        return ALL;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Set<RowKind> getContainedKinds() {
        return this.kinds;
    }

    public boolean contains(RowKind kind) {
        return this.kinds.contains(kind);
    }

    public boolean containsOnly(RowKind kind) {
        return this.kinds.size() == 1 && this.kinds.contains(kind);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangelogMode that = (ChangelogMode)o;
        return this.kinds.equals(that.kinds);
    }

    public int hashCode() {
        return Objects.hash(this.kinds);
    }

    public String toString() {
        return this.kinds.toString();
    }

    @PublicEvolving
    public static class Builder {
        private final Set<RowKind> kinds = EnumSet.noneOf(RowKind.class);

        private Builder() {
        }

        public Builder addContainedKind(RowKind kind) {
            this.kinds.add(kind);
            return this;
        }

        public ChangelogMode build() {
            return new ChangelogMode(this.kinds);
        }
    }
}

