/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table.batch.compact;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.flink.connector.file.table.BinPacking;
import org.apache.flink.connector.file.table.stream.compact.CompactMessages;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.function.SupplierWithException;

public class BatchCompactCoordinator
extends AbstractStreamOperator<CompactMessages.CoordinatorOutput>
implements OneInputStreamOperator<CompactMessages.CoordinatorInput, CompactMessages.CoordinatorOutput>,
BoundedOneInput {
    private static final long serialVersionUID = 1L;
    private final SupplierWithException<FileSystem, IOException> fsFactory;
    private final long compactAverageSize;
    private final long compactTargetSize;
    private transient FileSystem fs;
    private transient Map<String, List<Path>> inputFiles;
    private transient StreamRecord<CompactMessages.CoordinatorOutput> element;

    public BatchCompactCoordinator(SupplierWithException<FileSystem, IOException> fsFactory, long compactAverageSize, long compactTargetSize) {
        this.fsFactory = fsFactory;
        this.compactAverageSize = compactAverageSize;
        this.compactTargetSize = compactTargetSize;
    }

    public void open() throws Exception {
        this.fs = (FileSystem)this.fsFactory.get();
        this.inputFiles = new HashMap<String, List<Path>>();
        this.element = new StreamRecord(null);
    }

    public void processElement(StreamRecord<CompactMessages.CoordinatorInput> element) throws Exception {
        CompactMessages.CoordinatorInput coordinatorInput = (CompactMessages.CoordinatorInput)element.getValue();
        if (!(coordinatorInput instanceof CompactMessages.InputFile)) {
            throw new UnsupportedOperationException("Unsupported input message: " + coordinatorInput);
        }
        CompactMessages.InputFile file = (CompactMessages.InputFile)coordinatorInput;
        this.inputFiles.computeIfAbsent(file.getPartition(), k -> new ArrayList()).add(file.getFile());
    }

    public void endInput() throws Exception {
        for (Map.Entry<String, List<Path>> partitionFiles : this.inputFiles.entrySet()) {
            this.compactPartitionFiles(partitionFiles.getKey(), partitionFiles.getValue());
        }
    }

    public void close() throws Exception {
        this.inputFiles.clear();
    }

    private void compactPartitionFiles(String partition, List<Path> paths) throws IOException {
        if (paths.isEmpty()) {
            return;
        }
        int unitId = 0;
        Map<Path, Long> filesSize = this.getFilesSize(this.fs, paths);
        if (this.getAverageSize(filesSize) < (double)this.compactAverageSize) {
            Function<Path, Long> sizeFunc = filesSize::get;
            List<List<Path>> compactUnits = BinPacking.pack(paths, sizeFunc, this.compactTargetSize);
            for (List<Path> compactUnit : compactUnits) {
                this.output.collect((Object)this.element.replace((Object)new CompactMessages.CompactionUnit(unitId++, partition, compactUnit)));
            }
        } else {
            for (Path path : paths) {
                this.output.collect((Object)this.element.replace((Object)new CompactMessages.CompactionUnit(unitId++, partition, Collections.singletonList(path))));
            }
        }
    }

    private Map<Path, Long> getFilesSize(FileSystem fs, List<Path> paths) throws IOException {
        HashMap<Path, Long> filesSize = new HashMap<Path, Long>();
        for (Path path : paths) {
            long len = fs.getFileStatus(path).getLen();
            filesSize.put(path, len);
        }
        return filesSize;
    }

    private double getAverageSize(Map<Path, Long> filesSize) {
        int numFiles = 0;
        long totalSz = 0L;
        for (Map.Entry<Path, Long> fileSize : filesSize.entrySet()) {
            ++numFiles;
            totalSz += fileSize.getValue().longValue();
        }
        return (double)totalSz / ((double)numFiles * 1.0);
    }
}

