////////////////////////////////////////////////////////////////////////////////
//
//  Licensed to the Apache Software Foundation (ASF) under one or more
//  contributor license agreements.  See the NOTICE file distributed with
//  this work for additional information regarding copyright ownership.
//  The ASF licenses this file to You under the Apache License, Version 2.0
//  (the "License"); you may not use this file except in compliance with
//  the License.  You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

package
{

/**
 *  @private
 *  In some projects, this class is used to link additional classes
 *  into the SWC beyond those that are found by dependency analysis
 *  starting from the classes specified in manifest.xml.
 *  This project has no manifest file (because there are no MXML tags
 *  corresponding to any classes in it) so all the classes linked into
 *  the SWC are found by a dependency analysis starting from the classes
 *  listed here.
 */
internal class GraphiteClasses
{

import graphite.skins.ApplicationSkin; ApplicationSkin;
import graphite.skins.BorderSkin; BorderSkin;
import graphite.skins.ButtonBarFirstButtonSkin; ButtonBarFirstButtonSkin;
import graphite.skins.ButtonBarLastButtonSkin; ButtonBarLastButtonSkin;
import graphite.skins.ButtonBarMiddleButtonSkin; ButtonBarMiddleButtonSkin;
import graphite.skins.ButtonBarSkin; ButtonBarSkin;
import graphite.skins.ButtonSkin; ButtonSkin;
import graphite.skins.CheckBoxSkin; CheckBoxSkin;
import graphite.skins.ComboBoxButtonSkin; ComboBoxButtonSkin;
import graphite.skins.ComboBoxSkin; ComboBoxSkin;
import graphite.skins.ComboBoxTextInputSkin; ComboBoxTextInputSkin;
import graphite.skins.DefaultButtonSkin; DefaultButtonSkin;
import graphite.skins.DefaultComplexItemRenderer; DefaultComplexItemRenderer;
import graphite.skins.DefaultItemRenderer; DefaultItemRenderer;
import graphite.skins.DropDownListButtonSkin; DropDownListButtonSkin;
import graphite.skins.DropDownListSkin; DropDownListSkin;
import graphite.skins.ErrorSkin; ErrorSkin;
import graphite.skins.FocusSkin; FocusSkin;
import graphite.skins.HScrollBarSkin; HScrollBarSkin;
import graphite.skins.HScrollBarThumbSkin; HScrollBarThumbSkin;
import graphite.skins.HScrollBarTrackSkin; HScrollBarTrackSkin;
import graphite.skins.HSliderSkin; HSliderSkin;
import graphite.skins.HSliderThumbSkin; HSliderThumbSkin;
import graphite.skins.HSliderTrackSkin; HSliderTrackSkin;
import graphite.skins.HighlightBitmapCaptureSkin; HighlightBitmapCaptureSkin;
import graphite.skins.ListSkin; ListSkin;
import graphite.skins.NumericStepperSkin; NumericStepperSkin;
import graphite.skins.NumericStepperTextInputSkin; NumericStepperTextInputSkin;
import graphite.skins.PanelSkin; PanelSkin;
import graphite.skins.RadioButtonSkin; RadioButtonSkin;
import graphite.skins.ScrollBarDownButtonSkin; ScrollBarDownButtonSkin;
import graphite.skins.ScrollBarLeftButtonSkin; ScrollBarLeftButtonSkin;
import graphite.skins.ScrollBarRightButtonSkin; ScrollBarRightButtonSkin;
import graphite.skins.ScrollBarUpButtonSkin; ScrollBarUpButtonSkin;
import graphite.skins.ScrollerSkin; ScrollerSkin;
import graphite.skins.SkinnableContainerSkin; SkinnableContainerSkin;
import graphite.skins.SkinnableDataContainerSkin; SkinnableDataContainerSkin;
import graphite.skins.SpinnerDecrementButtonSkin; SpinnerDecrementButtonSkin;
import graphite.skins.SpinnerIncrementButtonSkin; SpinnerIncrementButtonSkin;
import graphite.skins.SpinnerSkin; SpinnerSkin;
import graphite.skins.TabBarButtonSkin; TabBarButtonSkin;
import graphite.skins.TabBarSkin; TabBarSkin;
import graphite.skins.TextAreaSkin; TextAreaSkin;
import graphite.skins.TextInputSkin; TextInputSkin;
import graphite.skins.TitleWindowCloseButtonSkin; TitleWindowCloseButtonSkin;
import graphite.skins.TitleWindowSkin; TitleWindowSkin;
import graphite.skins.ToggleButtonSkin; ToggleButtonSkin;
import graphite.skins.VScrollBarSkin; VScrollBarSkin;
import graphite.skins.VScrollBarThumbSkin; VScrollBarThumbSkin;
import graphite.skins.VScrollBarTrackSkin; VScrollBarTrackSkin;
import graphite.skins.VSliderSkin; VSliderSkin;
import graphite.skins.VSliderThumbSkin; VSliderThumbSkin;
import graphite.skins.VSliderTrackSkin; VSliderTrackSkin;
import graphite.skins.VideoPlayerSkin; VideoPlayerSkin;

}
}