/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flash.localization.ILocalizer;
import flash.localization.LocalizationManager;
import flash.localization.ResourceBundleLocalizer;
import flash.swf.Movie;
import flash.swf.MovieDecoder;
import flash.swf.MovieEncoder;
import flash.swf.TagDecoder;
import flash.swf.TagEncoder;
import flash.swf.TagHandler;
import flash.util.Trace;
import flex2.compiler.CompilerAPI;
import flex2.compiler.common.DefaultsConfigurator;
import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationFilter;
import flex2.compiler.config.ConfigurationInfo;
import flex2.compiler.config.ConfigurationValue;
import flex2.compiler.io.FileUtil;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.CommandLineConfiguration;
import flex2.tools.Mxmlc;
import flex2.tools.WebTierAPI;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.flex.tools.FlexTool;

public class Optimizer
implements FlexTool {
    public String getName() {
        return "OPTIMIZER";
    }

    public int execute(String[] args) {
        Optimizer.main(args);
        return 0;
    }

    public static void main(String[] args) {
        block6: {
            CompilerAPI.useAS3();
            CompilerAPI.usePathResolver();
            LocalizationManager l10n = new LocalizationManager();
            l10n.addLocalizer((ILocalizer)new ResourceBundleLocalizer());
            ThreadLocalToolkit.setLocalizationManager(l10n);
            CompilerAPI.useConsoleLogger();
            Object[] configVars = new String[]{"help", "version", "load-config", "input", "output", "compiler.keep-as3-metadata", "compiler.debug"};
            Arrays.sort(configVars);
            ConfigurationBuffer cfgbuf = new ConfigurationBuffer(OptimizerConfiguration.class, new HashMap<String, String>(), new ConfigurationFilter((String[])configVars){
                final /* synthetic */ String[] val$configVars;
                {
                    this.val$configVars = stringArray;
                }

                public boolean select(String name) {
                    return Arrays.binarySearch(this.val$configVars, name) >= 0;
                }
            });
            cfgbuf.setDefaultVar("input");
            try {
                DefaultsConfigurator.loadMinimumDefaults(cfgbuf);
                OptimizerConfiguration configuration = (OptimizerConfiguration)Mxmlc.processConfiguration(l10n, "optimizer", args, cfgbuf, OptimizerConfiguration.class, "input", true);
                configuration.setDebug(configuration.debug());
                configuration.setOptimize(true);
                String input = configuration.getInput();
                String output = configuration.getOutput();
                File inputFile = FileUtil.openFile(input);
                File outputFile = FileUtil.openFile(output);
                if (inputFile.exists()) {
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputFile));
                    System.out.println(input + " (" + inputFile.length() + " bytes)");
                    Movie movie = new Movie();
                    TagDecoder tagDecoder = new TagDecoder((InputStream)in);
                    MovieDecoder movieDecoder = new MovieDecoder(movie);
                    tagDecoder.parse((TagHandler)movieDecoder);
                    if (movie.version > 0) {
                        WebTierAPI.optimize(movie, configuration);
                        TagEncoder handler = new TagEncoder();
                        MovieEncoder encoder = new MovieEncoder((TagHandler)handler);
                        encoder.export(movie, true);
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        handler.writeTo((OutputStream)out);
                        FileUtil.writeBinaryFile(output, out.toByteArray());
                        System.out.println(output + " (" + outputFile.length() + " bytes)");
                    } else {
                        ThreadLocalToolkit.logError(l10n.getLocalizedTextString((Object)new NotAValidSwfFile(inputFile.getAbsolutePath())));
                    }
                }
            }
            catch (ConfigurationException ex) {
                Mxmlc.processConfigurationException(ex, "optimizer");
            }
            catch (IOException ex) {
                if (!Trace.error) break block6;
                ex.printStackTrace();
            }
        }
    }

    public static class NotAValidSwfFile
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 4755466826283937173L;
        public String fileName;

        public NotAValidSwfFile(String fileName) {
            this.fileName = fileName;
        }
    }

    public static class OptimizerConfiguration
    extends CommandLineConfiguration {
        private String input = null;
        private String output = "output.swf";

        public String getInput() {
            return this.input;
        }

        public void cfgInput(ConfigurationValue val, String input) throws ConfigurationException {
            this.input = input;
        }

        public static ConfigurationInfo getInputInfo() {
            return new ConfigurationInfo(1, "filename"){

                public boolean isRequired() {
                    return true;
                }
            };
        }

        public String getOutput() {
            return this.output;
        }

        public void cfgOutput(ConfigurationValue val, String output) throws ConfigurationException {
            this.output = output;
        }

        public static ConfigurationInfo getOutputInfo() {
            return new ConfigurationInfo(1, "filename"){

                public boolean isRequired() {
                    return false;
                }
            };
        }

        public void validate(ConfigurationBuffer cfgbuf) throws ConfigurationException {
        }
    }
}

