/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import macromedia.asc.parser.AttributeListNode;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.ExpressionStatementNode;
import macromedia.asc.parser.LoadRegisterNode;
import macromedia.asc.parser.Node;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.BitSet;
import macromedia.asc.util.Context;
import macromedia.asc.util.NumberUsage;
import macromedia.asc.util.ObjectList;

public class StatementListNode
extends Node {
    public ObjectList<Node> items = new ObjectList(5);
    public boolean dominates_program_endpoint = false;
    public boolean was_empty = false;
    public boolean is_loop = false;
    public boolean is_block = false;
    public boolean has_pragma = false;
    public NumberUsage numberUsage = null;
    public ObjectValue default_namespace;
    public AttributeListNode config_attrs;

    public StatementListNode(Node item) {
        if (item != null) {
            this.items.add(item);
        }
    }

    public Value evaluate(Context cx, Evaluator evaluator) {
        if (evaluator.checkFeature(cx, this)) {
            return evaluator.evaluate(cx, this);
        }
        return null;
    }

    public Node first() {
        return this.items.isEmpty() ? null : this.items.first();
    }

    public int countVars() {
        int count = 0;
        for (Node n : this.items) {
            if (n == null) continue;
            count += n.countVars();
        }
        return count;
    }

    public Node last() {
        return this.items.isEmpty() ? null : this.items.last();
    }

    public BitSet getGenBits() {
        BitSet genbits = null;
        for (Node n : this.items) {
            genbits = BitSet.reset_set(genbits, n.getKillBits(), n.getGenBits());
        }
        return genbits;
    }

    public BitSet getKillBits() {
        BitSet killbits = null;
        for (Node n : this.items) {
            killbits = BitSet.reset_set(killbits, n.getGenBits(), n.getKillBits());
        }
        return killbits;
    }

    public boolean isStatementList() {
        return true;
    }

    public String toString() {
        return this.items.last().toString();
    }

    public boolean definesCV() {
        for (Node n : this.items) {
            ExpressionStatementNode expr;
            if (!n.isExpressionStatement() || (expr = (ExpressionStatementNode)n).isVarStatement()) continue;
            return true;
        }
        return false;
    }

    public void voidResult() {
        for (Node n : this.items) {
            n.voidResult();
        }
        if (this.items.last() instanceof LoadRegisterNode) {
            ((LoadRegisterNode)this.items.last()).void_result = true;
        }
    }
}

