////////////////////////////////////////////////////////////////////////////////
//
//  Licensed to the Apache Software Foundation (ASF) under one or more
//  contributor license agreements.  See the NOTICE file distributed with
//  this work for additional information regarding copyright ownership.
//  The ASF licenses this file to You under the Apache License, Version 2.0
//  (the "License"); you may not use this file except in compliance with
//  the License.  You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////
package flashx.textLayout.formats
{
	/**
	 *  Defines a constant for specifying that the value of the <code>color</code> property
	 *  of the <code>TextLayoutFormat</code> class is "transparent".
	 *
	 * @playerversion Flash 10
	 * @playerversion AIR 1.5
	 * @langversion 3.0 
	 * @see flashx.textLayout.formats.TextLayoutFormat#color TextLayoutFormat.color
	 */
	public final class ColorName
	{
		/** Below are supported colorName values 
		 *
		 * @playerversion Flash 10
	 	 * @playerversion AIR 1.5
	 	 * @langversion 3.0
	 	 */
	 	
		public static const BLACK:String   = "black";  //0x000000;
		public static const BLUE:String    = "blue";   //0x0000FF;
		public static const GREEN:String   = "green";  //0x008000;
		public static const GRAY:String    = "gray";   //0x808080;
		public static const SILVER:String  = "silver"; //0xC0C0C0;
		public static const LIME:String    = "lime";   //0x00FF00;
		public static const OLIVE:String   = "olive";  //0x808000;
		public static const WHITE:String   = "white";  //0xFFFFFF;
		public static const YELLOW:String  = "yellow"; //0xFFFF00;
		public static const MAROON:String  = "maroon"; //0x800000;
		public static const NAVY:String    = "navy";   //0x000080;
		public static const RED:String     = "red";    //0xFF0000;
		public static const PURPLE:String  = "purple"; //0x800080;
		public static const TEAL:String    = "teal";   //0x008080;
		public static const FUCHSIA:String = "fuchsia";//0xFF00FF;
		public static const AQUA:String    = "aqua";   //0x00FFFF;
		public static const MAGENTA:String = "magenta";//0xFF00FF;
		public static const CYAN:String    = "cyan";   //0x00FFFF;	
	}
}