/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.felix.webconsole.internal.misc;


import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;

import org.apache.felix.inventory.Format;
import org.apache.felix.webconsole.internal.AbstractConfigurationPrinter;


public class SystemPropertiesPrinter extends AbstractConfigurationPrinter {

    private static final String TITLE = "System Properties";

    @Override
    protected String getTitle() {
        return TITLE;
    }

    @Override
    public void print(final PrintWriter pw, final Format format, final boolean isZip) {
        Properties props = System.getProperties();
        SortedSet<?> keys = new TreeSet<>( props.keySet() );
        for ( Iterator<?> ki = keys.iterator(); ki.hasNext(); ) {
            Object key = ki.next();
            ConfigurationRender.infoLine( pw, null, ( String ) key, props.get( key ) );
        }

    }
}