/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.core.impl.scheduling.cron.quartz;

import org.apache.felix.hc.core.impl.executor.HealthCheckExecutorThreadPool;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.DirectSchedulerFactory;
import org.quartz.simpl.RAMJobStore;
import org.quartz.spi.JobStore;
import org.quartz.spi.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzCronScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(QuartzCronScheduler.class);
    private static final String HC_SCHEDULER_NAME = "quartz.hc.scheduler_name";
    private Scheduler scheduler;

    public QuartzCronScheduler(HealthCheckExecutorThreadPool healthCheckExecutorThreadPool) {
        try {
            DirectSchedulerFactory schedulerFactory = DirectSchedulerFactory.getInstance();
            QuartzThreadPool threadPool = new QuartzThreadPool(healthCheckExecutorThreadPool);
            schedulerFactory.createScheduler(HC_SCHEDULER_NAME, "id_" + System.currentTimeMillis(), (ThreadPool)threadPool, (JobStore)new RAMJobStore());
            this.scheduler = schedulerFactory.getScheduler(HC_SCHEDULER_NAME);
            this.scheduler.start();
            LOG.debug("Started quartz scheduler {}", (Object)this.scheduler);
        }
        catch (SchedulerException e) {
            throw new IllegalStateException("Could not initialise/start quartz scheduler quartz.hc.scheduler_name", e);
        }
    }

    public void shutdown() {
        if (this.scheduler != null) {
            try {
                this.scheduler.shutdown(false);
                LOG.debug("Shutdown of quartz scheduler finished: {}", (Object)this.scheduler);
            }
            catch (SchedulerException e) {
                throw new IllegalStateException("Could not shutdown quartz scheduler quartz.hc.scheduler_name", e);
            }
        }
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public class QuartzThreadPool
    implements ThreadPool {
        private final HealthCheckExecutorThreadPool healthCheckExecutorThreadPool;

        public QuartzThreadPool(HealthCheckExecutorThreadPool healthCheckExecutorThreadPool) {
            this.healthCheckExecutorThreadPool = healthCheckExecutorThreadPool;
        }

        public int getPoolSize() {
            return this.healthCheckExecutorThreadPool.getPoolSize();
        }

        public void initialize() {
        }

        public void setInstanceId(String id) {
        }

        public void setInstanceName(String name) {
        }

        public boolean runInThread(Runnable job) {
            this.healthCheckExecutorThreadPool.execute(job);
            return true;
        }

        public int blockForAvailableThreads() {
            return this.healthCheckExecutorThreadPool.getMaxCurrentlyAvailableThreads();
        }

        public void shutdown(boolean waitForJobsToComplete) {
        }
    }
}

