/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.ByteBufferCursor;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ShapefileByteBufferCursor
extends ByteBufferCursor {
    ByteBuffer fileBuffer;
    int headerOffset;
    int currOffset;
    int fileLen;
    int recordIndex;

    public ShapefileByteBufferCursor(ByteBuffer buffer) {
        this.currOffset = this.headerOffset = 100;
        this.recordIndex = 0;
        this.fileBuffer = buffer;
        this.fileBuffer.order(ByteOrder.BIG_ENDIAN);
        int fileLengthWords = this.fileBuffer.getInt(24);
        this.fileLen = fileLengthWords * 2;
    }

    public int getByteBufferID() {
        return this.recordIndex;
    }

    public ByteBuffer next() {
        ByteBuffer shpGeometryRow = this.getSingleRowFromShp();
        return shpGeometryRow;
    }

    private ByteBuffer getSingleRowFromShp() {
        this.fileBuffer.order(ByteOrder.BIG_ENDIAN);
        ByteBuffer shapeBuffer = null;
        if (this.currOffset < this.fileLen) {
            this.fileBuffer.order(ByteOrder.BIG_ENDIAN);
            this.recordIndex = this.fileBuffer.getInt(this.currOffset);
            int contentLen = this.fileBuffer.getInt(this.currOffset + 4) * 2;
            this.fileBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byte[] dstArr = new byte[contentLen];
            this.fileBuffer.position(this.currOffset + 8);
            this.fileBuffer.get(dstArr, 0, contentLen);
            shapeBuffer = ByteBuffer.wrap(dstArr);
            shapeBuffer.order(ByteOrder.LITTLE_ENDIAN);
            int tmpPos = shapeBuffer.position();
            shapeBuffer.position(tmpPos);
            this.currOffset = this.currOffset + 8 + contentLen;
        }
        return shapeBuffer;
    }
}

