/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.hdfs.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingRejectionHandler
implements RejectedExecutionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BlockingRejectionHandler.class);
    private final long timeout;

    public BlockingRejectionHandler(long timeout) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout must be positive");
        }
        this.timeout = timeout;
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Initializing %s with timeout: %d seconds", this.getClass().getSimpleName(), this.timeout));
        }
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        if (executor.isShutdown()) {
            throw new RejectedExecutionException("The executor has already been shutdown");
        }
        BlockingQueue<Runnable> executorQueue = executor.getQueue();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Attempting to block and queue task, timeout: %d seconds", this.timeout));
            }
            if (!executorQueue.offer(r, this.timeout, TimeUnit.SECONDS)) {
                throw new RejectedExecutionException(String.format("Timed-out enqueue of blocking queue, duration %d seconds", this.timeout));
            }
            LOG.debug("BlockingHandler successfully queued task");
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RejectedExecutionException("Interrupted while waiting to enqueue task");
        }
    }
}

