/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.hdfs.store;

import com.oracle.bmc.objectstorage.ObjectStorage;
import com.oracle.bmc.objectstorage.requests.RenameObjectRequest;
import com.oracle.bmc.objectstorage.responses.RenameObjectResponse;
import java.beans.ConstructorProperties;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameOperation
implements Callable<String> {
    private static final Logger LOG = LoggerFactory.getLogger(RenameOperation.class);
    private final ObjectStorage objectStorage;
    private final RenameObjectRequest renameRequest;

    @Override
    public String call() throws Exception {
        LOG.debug("Renaming object from {} to {}.", (Object)this.renameRequest.getRenameObjectDetails().getSourceName(), (Object)this.renameRequest.getRenameObjectDetails().getNewName());
        RenameObjectResponse renameResponse = this.objectStorage.renameObject(this.renameRequest);
        return renameResponse.getETag();
    }

    @ConstructorProperties(value={"objectStorage", "renameRequest"})
    public RenameOperation(ObjectStorage objectStorage, RenameObjectRequest renameRequest) {
        this.objectStorage = objectStorage;
        this.renameRequest = renameRequest;
    }
}

