/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.hdfs.store;

import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.objectstorage.ObjectStorage;
import com.oracle.bmc.objectstorage.requests.CreateMultipartUploadRequest;
import com.oracle.bmc.retrier.DefaultRetryCondition;
import com.oracle.bmc.retrier.RetryCondition;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.ExponentialBackoffDelayStrategy;
import com.oracle.bmc.waiter.MaxAttemptsTerminationStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import java.util.Objects;
import lombok.NonNull;

public class MultipartUploadRequest {
    private final CreateMultipartUploadRequest multipartUploadRequest;
    private ObjectStorage objectStorage;
    private boolean allowOverwrite;
    private RetryConfiguration retryConfiguration;
    private static final RetryCondition RETRY_CONDITION = new DefaultRetryCondition(){

        public boolean shouldBeRetried(@NonNull BmcException e) {
            if (e == null) {
                throw new NullPointerException("e is marked non-null but is null");
            }
            return super.shouldBeRetried(e) || e.getStatusCode() == 409 && "ConcurrentObjectUpdate".equals(e.getServiceCode());
        }
    };
    static final RetryConfiguration RETRY_CONFIGURATION = RetryConfiguration.builder().terminationStrategy((TerminationStrategy)new MaxAttemptsTerminationStrategy(5)).delayStrategy((DelayStrategy)new ExponentialBackoffDelayStrategy(100L)).retryCondition(exception -> RETRY_CONDITION.shouldBeRetried(exception)).build();

    MultipartUploadRequest(@NonNull CreateMultipartUploadRequest multipartUploadRequest, @NonNull ObjectStorage objectStorage, boolean allowOverwrite, RetryConfiguration retryConfiguration) {
        if (objectStorage == null) {
            throw new NullPointerException("objectStorage is marked non-null but is null");
        }
        this.multipartUploadRequest = Objects.requireNonNull(multipartUploadRequest, "multipartUploadRequest must be non-null");
        if (multipartUploadRequest.getCreateMultipartUploadDetails() == null) {
            throw new NullPointerException("CreateMultipartUploadDetails must be non-null");
        }
        this.objectStorage = Objects.requireNonNull(objectStorage, "objectStorage must be non-null");
        this.allowOverwrite = allowOverwrite;
        this.retryConfiguration = retryConfiguration == null ? RETRY_CONFIGURATION : retryConfiguration;
    }

    public static MultipartUploadRequestBuilder builder() {
        return new MultipartUploadRequestBuilder();
    }

    public CreateMultipartUploadRequest getMultipartUploadRequest() {
        return this.multipartUploadRequest;
    }

    public ObjectStorage getObjectStorage() {
        return this.objectStorage;
    }

    public boolean isAllowOverwrite() {
        return this.allowOverwrite;
    }

    public RetryConfiguration getRetryConfiguration() {
        return this.retryConfiguration;
    }

    public static class MultipartUploadRequestBuilder {
        private CreateMultipartUploadRequest multipartUploadRequest;
        private ObjectStorage objectStorage;
        private boolean allowOverwrite;
        private RetryConfiguration retryConfiguration;

        MultipartUploadRequestBuilder() {
        }

        public MultipartUploadRequestBuilder multipartUploadRequest(@NonNull CreateMultipartUploadRequest multipartUploadRequest) {
            if (multipartUploadRequest == null) {
                throw new NullPointerException("multipartUploadRequest is marked non-null but is null");
            }
            this.multipartUploadRequest = multipartUploadRequest;
            return this;
        }

        public MultipartUploadRequestBuilder objectStorage(@NonNull ObjectStorage objectStorage) {
            if (objectStorage == null) {
                throw new NullPointerException("objectStorage is marked non-null but is null");
            }
            this.objectStorage = objectStorage;
            return this;
        }

        public MultipartUploadRequestBuilder allowOverwrite(boolean allowOverwrite) {
            this.allowOverwrite = allowOverwrite;
            return this;
        }

        public MultipartUploadRequestBuilder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public MultipartUploadRequest build() {
            return new MultipartUploadRequest(this.multipartUploadRequest, this.objectStorage, this.allowOverwrite, this.retryConfiguration);
        }

        public String toString() {
            return "MultipartUploadRequest.MultipartUploadRequestBuilder(multipartUploadRequest=" + this.multipartUploadRequest + ", objectStorage=" + this.objectStorage + ", allowOverwrite=" + this.allowOverwrite + ", retryConfiguration=" + this.retryConfiguration + ")";
        }
    }
}

