/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.hdfs.store;

import com.oracle.bmc.hdfs.store.BmcOutputStream;
import com.oracle.bmc.hdfs.store.BmcPropertyAccessor;
import com.oracle.bmc.hdfs.util.BiFunction;
import com.oracle.bmc.objectstorage.transfer.UploadManager;
import com.oracle.bmc.util.StreamUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BmcFileBackedOutputStream
extends BmcOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(BmcFileBackedOutputStream.class);
    private final BmcPropertyAccessor propertyAccessor;
    private File bufferFile;

    public BmcFileBackedOutputStream(BmcPropertyAccessor propertyAccessor, UploadManager uploadManager, BiFunction<Long, InputStream, UploadManager.UploadRequest> requestBuilderFn) {
        super(uploadManager, requestBuilderFn);
        this.propertyAccessor = propertyAccessor;
    }

    @Override
    protected OutputStream createOutputBufferStream() throws IOException {
        this.bufferFile = this.createBufferFile();
        return new BufferedOutputStream(new FileOutputStream(this.bufferFile));
    }

    @Override
    protected InputStream getInputStreamFromBufferedStream() {
        return StreamUtils.toInputStream((File)this.bufferFile);
    }

    @Override
    protected long getInputStreamLengthInBytes() {
        return this.bufferFile.length();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.bufferFile.delete();
    }

    private File createBufferFile() throws IOException {
        File dir = new File(this.propertyAccessor.get("hadoop.tmp.dir"));
        if (!dir.exists()) {
            dir.mkdirs();
            if (!dir.exists()) {
                throw new IOException("Unable to create temp file: " + dir);
            }
        }
        File result = File.createTempFile("oci-", ".tmp", dir);
        LOG.debug("Created temp file {}", (Object)result.getAbsolutePath());
        result.deleteOnExit();
        return result;
    }
}

