/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.hdfs.caching;

import com.oracle.bmc.hdfs.caching.CachingObjectStorage;
import com.oracle.bmc.hdfs.caching.ConsistencyPolicy;
import com.oracle.bmc.model.Range;
import com.oracle.bmc.objectstorage.ObjectStorage;
import com.oracle.bmc.objectstorage.requests.GetObjectRequest;
import com.oracle.bmc.objectstorage.responses.GetObjectResponse;
import com.oracle.bmc.objectstorage.transfer.DownloadManager;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrongConsistencyPolicy
implements ConsistencyPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(StrongConsistencyPolicy.class);

    @Override
    public CachingObjectStorage.GetObjectRequestCacheKey constructKey(GetObjectRequest request) {
        return new CachingObjectStorage.GetObjectRequestCacheKey(GetObjectRequest.builder().copy(request).opcClientRequestId(null).retryConfiguration(null).invocationCallback(null).ifMatch(null).build());
    }

    @Override
    public GetObjectResponse initiateRequest(ObjectStorage client, DownloadManager downloadManager, GetObjectRequest request, CachingObjectStorage.GetObjectRequestCacheKey key, CachingObjectStorage.GetObjectResponseCacheValue previousValue) {
        if (request.getIfMatch() == null) {
            return this.withoutIfMatch(client, downloadManager, request, key, previousValue);
        }
        return this.withIfMatch(client, downloadManager, request, key, previousValue);
    }

    private GetObjectResponse withoutIfMatch(ObjectStorage client, DownloadManager downloadManager, GetObjectRequest request, CachingObjectStorage.GetObjectRequestCacheKey key, CachingObjectStorage.GetObjectResponseCacheValue previousValue) {
        GetObjectResponse object;
        GetObjectRequest.Builder builder = GetObjectRequest.builder().copy(request);
        String previousEtag = null;
        if (previousValue != null) {
            previousEtag = previousValue.getOriginalResponse().getETag();
        }
        builder = CachingObjectStorage.Handler.updateRequestId(builder, request);
        if (previousEtag != null) {
            LOG.debug("Making get request with if-none-match='{}' check for key='{}'", (Object)previousEtag, (Object)key);
            builder = builder.ifNoneMatch(previousEtag);
            object = client.getObject(builder.build());
        } else {
            LOG.debug("Making new get request (without if-none-match check) for key='{}'", (Object)key);
            object = downloadManager.getObject(builder.build());
        }
        LOG.debug("Service returned '{}-{}' for key='{}', ETag is '{}', body is '{}'", new Object[]{object.get__httpStatusCode__(), Response.Status.fromStatusCode((int)object.get__httpStatusCode__()).getReasonPhrase(), key, object.getETag(), object.getInputStream()});
        if (object.get__httpStatusCode__() == Response.Status.NOT_MODIFIED.getStatusCode()) {
            return null;
        }
        return object;
    }

    private GetObjectResponse withIfMatch(ObjectStorage client, DownloadManager downloadManager, GetObjectRequest request, CachingObjectStorage.GetObjectRequestCacheKey key, CachingObjectStorage.GetObjectResponseCacheValue previousValue) {
        String previousEtag = null;
        if (previousValue != null) {
            previousEtag = previousValue.getOriginalResponse().getETag();
        }
        if (previousEtag == null) {
            LOG.trace("New previously uncached request for '{}'", (Object)key);
            GetObjectRequest.Builder builder = GetObjectRequest.builder().copy(request);
            builder = CachingObjectStorage.Handler.updateRequestId(builder, request);
            GetObjectResponse getObjectResponse = downloadManager.getObject(builder.build());
            return getObjectResponse;
        }
        if (request.getIfMatch().equals(previousEtag)) {
            LOG.trace("Previously cached request with same etag '{}' for '{}'", (Object)previousEtag, (Object)key);
            GetObjectRequest.Builder builder = GetObjectRequest.builder().copy(request).range(new Range(Long.valueOf(0L), Long.valueOf(0L)));
            builder = CachingObjectStorage.Handler.updateRequestId(builder, request);
            GetObjectResponse shortRangeResult = client.getObject(builder.build());
            LOG.trace("Etag is still '{}' for '{}', using cached data", (Object)previousEtag, (Object)key);
            return null;
        }
        LOG.trace("Request with if-match '{}' for previously cached request with different etag '{}' for '{}'", new Object[]{request.getIfMatch(), previousEtag, key});
        GetObjectRequest.Builder builder = GetObjectRequest.builder().copy(request);
        GetObjectResponse getObjectResponse = downloadManager.getObject(builder.build());
        LOG.trace("Etag matched if-match in request '{}', not previous etag '{}', updating cache for '{}'", new Object[]{request.getIfMatch(), previousEtag, key});
        return getObjectResponse;
    }
}

