/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.hdfs;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public final class BmcConstants {
    public static final String OCI_SCHEME = "oci";
    static final int DEFAULT_PORT = -1;
    public static final String BLOCK_SIZE_IN_MB_KEY = "fs.oci.blocksize.mb";
    public static final String IN_MEMORY_WRITE_BUFFER_KEY = "fs.oci.io.write.inmemory";
    public static final String IN_MEMORY_READ_BUFFER_KEY = "fs.oci.io.read.inmemory";
    public static final String MULTIPART_IN_MEMORY_WRITE_BUFFER_ENABLED_KEY = "fs.oci.io.write.multipart.inmemory";
    public static final String MULTIPART_IN_MEMORY_WRITE_TASK_TIMEOUT_SECONDS_KEY = "fs.oci.io.write.multipart.inmemory.tasktimeout.seconds";
    public static final String MULTIPART_ALLOW_OVERWRITE_KEY = "fs.oci.io.write.multipart.overwrite";
    public static final String READ_AHEAD_KEY = "fs.oci.io.read.ahead";
    public static final String READ_AHEAD_BLOCK_SIZE_KEY = "fs.oci.io.read.ahead.blocksize";
    public static final String READ_STREAM_CLASS_KEY = "fs.oci.io.read.custom.stream";
    public static final String WRITE_STREAM_CLASS_KEY = "fs.oci.io.write.custom.stream";
    public static final String OBJECT_STORE_CLIENT_CLASS_KEY = "fs.oci.client.custom.client";
    public static final String OBJECT_STORE_AUTHENTICATOR_CLASS_KEY = "fs.oci.client.custom.authenticator";
    public static final String HOST_NAME_KEY = "fs.oci.client.hostname";
    public static final String TENANT_ID_KEY = "fs.oci.client.auth.tenantId";
    public static final String USER_ID_KEY = "fs.oci.client.auth.userId";
    public static final String FINGERPRINT_KEY = "fs.oci.client.auth.fingerprint";
    public static final String PEM_FILE_PATH_KEY = "fs.oci.client.auth.pemfilepath";
    public static final String PASS_PHRASE_KEY = "fs.oci.client.auth.passphrase";
    public static final String REGION_CODE_OR_ID_KEY = "fs.oci.client.regionCodeOrId";
    public static final String CONNECTION_TIMEOUT_MILLIS_KEY = "fs.oci.client.http.connectiontimeout";
    public static final String READ_TIMEOUT_MILLIS_KEY = "fs.oci.client.http.readtimeout";
    public static final String MULTIPART_ALLOWED_KEY = "fs.oci.client.multipart.allowed";
    public static final String MULTIPART_NUM_UPLOAD_THREADS_KEY = "fs.oci.client.multipart.numthreads";
    public static final String MULTIPART_MIN_SIZE_OF_OBJECT_IN_MB_KEY = "fs.oci.client.multipart.minobjectsize.mb";
    @java.lang.Deprecated
    public static final String MULTIPART_MIN_PART_SIZE_IN_MB_KEY = "fs.oci.client.multipart.minpartsize.mb";
    public static final String MULTIPART_PART_SIZE_IN_MB_KEY = "fs.oci.client.multipart.partsize.mb";
    public static final String HTTP_PROXY_URI_KEY = "fs.oci.client.proxy.uri";
    public static final String HTTP_PROXY_USERNAME_KEY = "fs.oci.client.proxy.username";
    public static final String HTTP_PROXY_PASSWORD_KEY = "fs.oci.client.proxy.password";
    public static final String RETRY_TIMEOUT_IN_SECONDS_KEY = "fs.oci.client.retry.timeout.seconds";
    public static final String RETRY_TIMEOUT_RESET_THRESHOLD_IN_SECONDS_KEY = "fs.oci.client.retry.reset.threshold.seconds";
    public static final String OBJECT_METADATA_CACHING_ENABLED_KEY = "fs.oci.caching.object.metadata.enabled";
    public static final String OBJECT_METADATA_CACHING_SPEC_KEY = "fs.oci.caching.object.metadata.spec";
    public static final String JERSEY_CLIENT_LOGGING_ENABLED_KEY = "fs.oci.client.jersey.logging.enabled";
    public static final String JERSEY_CLIENT_LOGGING_LEVEL_KEY = "fs.oci.client.jersey.logging.level";
    public static final String JERSEY_CLIENT_LOGGING_VERBOSITY_KEY = "fs.oci.client.jersey.logging.verbosity";
    public static final String OBJECT_PARQUET_CACHING_ENABLED_KEY = "fs.oci.caching.object.parquet.enabled";
    public static final String OBJECT_PARQUET_CACHING_SPEC_KEY = "fs.oci.caching.object.parquet.spec";
    public static final String RENAME_DIRECTORY_NUM_THREADS_KEY = "fs.oci.rename.operation.numthreads";
    public static final String APACHE_CONNECTION_CLOSING_STRATEGY_KEY = "fs.oci.client.apache.connection.closing.strategy";
    public static final String OBJECT_PAYLOAD_CACHING_ENABLED_KEY = "fs.oci.caching.object.payload.enabled";
    public static final String OBJECT_PAYLOAD_CACHING_MAXIMUM_WEIGHT_IN_BYTES_KEY = "fs.oci.caching.object.payload.maxweight.bytes";
    public static final String OBJECT_PAYLOAD_CACHING_MAXIMUM_SIZE_KEY = "fs.oci.caching.object.payload.maxsize.count";
    public static final String OBJECT_PAYLOAD_CACHING_INITIAL_CAPACITY_KEY = "fs.oci.caching.object.payload.initialcapacity.count";
    public static final String OBJECT_PAYLOAD_CACHING_RECORD_STATS_ENABLED_KEY = "fs.oci.caching.object.payload.recordstats.enabled";
    public static final String OBJECT_PAYLOAD_CACHING_RECORD_STATS_TIME_INTERVAL_IN_SECONDS_KEY = "fs.oci.caching.object.payload.recordstats.timeinterval.seconds";
    public static final String OBJECT_PAYLOAD_CACHING_EXPIRE_AFTER_ACCESS_SECONDS_KEY = "fs.oci.caching.object.payload.expireafteraccess.seconds";
    public static final String OBJECT_PAYLOAD_CACHING_EXPIRE_AFTER_WRITE_SECONDS_KEY = "fs.oci.caching.object.payload.expireafterwrite.seconds";
    public static final String OBJECT_PAYLOAD_CACHING_CONSISTENCY_POLICY_CLASS_KEY = "fs.oci.caching.object.payload.consistencypolicy.class";
    public static final String OBJECT_PAYLOAD_CACHING_DIRECTORY_KEY = "fs.oci.caching.object.payload.directory";
    public static final String JERSEY_CLIENT_DEFAULT_CONNECTOR_ENABLED_KEY = "fs.oci.client.jersey.default.connector.enabled";
    public static final String APACHE_MAX_CONNECTION_POOL_SIZE_KEY = "fs.oci.client.apache.max.connection.pool.size";
    public static final String OBJECT_AUTO_CLOSE_INPUT_STREAM_KEY = "fs.oci.object.autoclose.inputstream";
    public static final String FILESYSTEM_CACHING_ENABLED_KEY = "fs.oci.caching.filesystem.enabled";
    public static final String FILESYSTEM_CACHING_MAXIMUM_SIZE_KEY = "fs.oci.caching.filesystem.maxsize.count";
    public static final String FILESYSTEM_CACHING_INITIAL_CAPACITY_KEY = "fs.oci.caching.filesystem.initialcapacity.count";
    public static final String FILESYSTEM_CACHING_EXPIRE_AFTER_ACCESS_SECONDS_KEY = "fs.oci.caching.filesystem.expireafteraccess.seconds";
    public static final String FILESYSTEM_CACHING_EXPIRE_AFTER_WRITE_SECONDS_KEY = "fs.oci.caching.filesystem.expireafterwrite.seconds";

    private BmcConstants() {
    }

    public static enum Deprecated {

        public static final String BMC_SCHEME = "oraclebmc";
        private static final Map<String, String> NEW_TO_OLD_KEYS = ImmutableMap.builder().put((Object)"fs.oci.blocksize.mb", (Object)"fs.oraclebmc.blocksize.mb").put((Object)"fs.oci.io.write.inmemory", (Object)"fs.oraclebmc.io.write.inmemory").put((Object)"fs.oci.io.read.inmemory", (Object)"fs.oraclebmc.io.read.inmemory").put((Object)"fs.oci.client.custom.client", (Object)"fs.oraclebmc.client.custom.client").put((Object)"fs.oci.client.custom.authenticator", (Object)"fs.oraclebmc.client.custom.authenticator").put((Object)"fs.oci.client.hostname", (Object)"fs.oraclebmc.client.hostname").put((Object)"fs.oci.client.auth.tenantId", (Object)"fs.oraclebmc.client.auth.tenantId").put((Object)"fs.oci.client.auth.userId", (Object)"fs.oraclebmc.client.auth.userId").put((Object)"fs.oci.client.auth.fingerprint", (Object)"fs.oraclebmc.client.auth.fingerprint").put((Object)"fs.oci.client.auth.pemfilepath", (Object)"fs.oraclebmc.client.auth.pemfilepath").put((Object)"fs.oci.client.auth.passphrase", (Object)"fs.oraclebmc.client.auth.passphrase").put((Object)"fs.oci.client.regionCodeOrId", (Object)"fs.oraclebmc.client.regionCodeOrId").put((Object)"fs.oci.client.http.connectiontimeout", (Object)"fs.oraclebmc.client.http.connectiontimeout").put((Object)"fs.oci.client.http.readtimeout", (Object)"fs.oraclebmc.client.http.readtimeout").put((Object)"fs.oci.client.multipart.allowed", (Object)"fs.oraclebmc.client.multipart.allowed").put((Object)"fs.oci.client.multipart.numthreads", (Object)"fs.oraclebmc.client.multipart.numthreads").put((Object)"fs.oci.client.multipart.minobjectsize.mb", (Object)"fs.oraclebmc.client.multipart.minobjectsize.mb").put((Object)"fs.oci.client.multipart.partsize.mb", (Object)"fs.oraclebmc.client.multipart.partsize.mb").put((Object)"fs.oci.client.multipart.minpartsize.mb", (Object)"fs.oraclebmc.client.multipart.minpartsize.mb").put((Object)"fs.oci.client.proxy.uri", (Object)"fs.oraclebmc.client.proxy.uri").put((Object)"fs.oci.client.proxy.username", (Object)"fs.oraclebmc.client.proxy.username").put((Object)"fs.oci.client.proxy.password", (Object)"fs.oraclebmc.client.proxy.password").put((Object)"fs.oci.client.retry.timeout.seconds", (Object)"fs.oraclebmc.client.retry.timeout.seconds").put((Object)"fs.oci.client.retry.reset.threshold.seconds", (Object)"fs.oraclebmc.client.retry.reset.threshold.seconds").put((Object)"fs.oci.caching.object.metadata.enabled", (Object)"fs.oraclebmc.caching.object.metadata.enabled").put((Object)"fs.oci.caching.object.metadata.spec", (Object)"fs.oraclebmc.caching.object.metadata.spec").put((Object)"fs.oci.client.jersey.logging.enabled", (Object)"fs.oraclebmc.client.jersey.logging.enabled").put((Object)"fs.oci.client.jersey.logging.level", (Object)"fs.oraclebmc.client.jersey.logging.level").put((Object)"fs.oci.client.jersey.logging.verbosity", (Object)"fs.oraclebmc.client.jersey.logging.verbosity").put((Object)"fs.oci.client.jersey.default.connector.enabled", (Object)"fs.oraclebmc.client.jersey.default.connector.enabled").put((Object)"fs.oci.client.apache.max.connection.pool.size", (Object)"fs.oraclebmc.client.apache.max.connection.pool.size").put((Object)"fs.oci.rename.operation.numthreads", (Object)"fs.oraclebmc.rename.operation.numthreads").put((Object)"fs.oci.client.apache.connection.closing.strategy", (Object)"fs.oraclebmc.client.apache.connection.closing.strategy").put((Object)"fs.oci.object.autoclose.inputstream", (Object)"fs.oraclebmc.object.autoclose.inputstream").build();
        private static final String FS_OCI_PREFIX = "fs.oci.";

        public static String getDeprecatedKey(String newKey) {
            String oldKey = NEW_TO_OLD_KEYS.get(newKey);
            if (oldKey == null) {
                if (!newKey.startsWith(FS_OCI_PREFIX)) {
                    throw new IllegalArgumentException("Cannot determine old key for '" + newKey + "'");
                }
                oldKey = "fs.oraclebmc." + newKey.substring(FS_OCI_PREFIX.length());
            }
            return oldKey;
        }
    }
}

