/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.mongo.transform;

import com.google.gson.Gson;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.drill.metastore.MetastoreColumn;
import org.apache.drill.metastore.mongo.exception.MongoMetastoreException;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;
import org.bson.Document;

public class InputDataTransformer<T> {
    private static final Gson GSON = new Gson();
    private final List<T> units = new ArrayList<T>();
    private final Map<String, MethodHandle> unitGetters;

    public InputDataTransformer(Map<String, MethodHandle> unitGetters) {
        this.unitGetters = unitGetters;
    }

    public InputDataTransformer<T> units(List<T> units) {
        this.units.addAll(units);
        return this;
    }

    public Document createId(Document document) {
        return Document.parse((String)GSON.toJson((Object)ImmutableMap.of((Object)MetastoreColumn.STORAGE_PLUGIN.columnName(), (Object)document.get((Object)MetastoreColumn.STORAGE_PLUGIN.columnName()), (Object)MetastoreColumn.WORKSPACE.columnName(), (Object)document.get((Object)MetastoreColumn.WORKSPACE.columnName()), (Object)MetastoreColumn.TABLE_NAME.columnName(), (Object)document.get((Object)MetastoreColumn.TABLE_NAME.columnName()), (Object)MetastoreColumn.METADATA_TYPE.columnName(), (Object)document.get((Object)MetastoreColumn.METADATA_TYPE.columnName()), (Object)MetastoreColumn.METADATA_IDENTIFIER.columnName(), (Object)document.get((Object)MetastoreColumn.METADATA_IDENTIFIER.columnName()))));
    }

    public List<Document> execute() {
        return this.units.stream().map(unit -> {
            Document document = new Document();
            for (Map.Entry<String, MethodHandle> entry : this.unitGetters.entrySet()) {
                try {
                    document.put(entry.getKey(), entry.getValue().invoke(unit));
                }
                catch (Throwable e) {
                    throw new MongoMetastoreException(String.format("Unable to invoke getter for column [%s] using [%s]", entry.getKey(), entry.getValue()), e);
                }
            }
            return document.append("_id", (Object)this.createId(document));
        }).collect(Collectors.toList());
    }
}

