/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.mongo.operate;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.drill.metastore.MetastoreColumn;
import org.apache.drill.metastore.mongo.MongoMetastoreContext;
import org.apache.drill.metastore.mongo.transform.FilterTransformer;
import org.apache.drill.metastore.operate.AbstractRead;
import org.apache.drill.metastore.operate.MetadataTypeValidator;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.bson.conversions.Bson;

public class MongoRead<T>
extends AbstractRead<T> {
    private final MongoMetastoreContext<T> context;

    public MongoRead(MetadataTypeValidator metadataTypeValidator, MongoMetastoreContext<T> context) {
        super(metadataTypeValidator);
        this.context = context;
    }

    protected List<T> internalExecute() {
        FilterTransformer filterTransformer = this.context.transformer().filter();
        Bson rowFilter = filterTransformer.combine(filterTransformer.transform(this.metadataTypes), filterTransformer.transform(this.filter));
        LinkedList documents = Lists.newLinkedList();
        this.context.table().find(rowFilter).forEach(documents::add);
        return this.context.transformer().outputData().columns(this.columns.stream().map(MetastoreColumn::columnName).collect(Collectors.toList())).documents(documents).execute();
    }
}

