/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.mongo.operate;

import com.mongodb.client.ClientSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.drill.metastore.mongo.MongoMetastoreContext;
import org.apache.drill.metastore.mongo.operate.MongoOperation;
import org.apache.drill.metastore.mongo.transform.OperationTransformer;
import org.apache.drill.metastore.operate.AbstractModify;
import org.apache.drill.metastore.operate.Delete;
import org.apache.drill.metastore.operate.MetadataTypeValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoModify<T>
extends AbstractModify<T> {
    private static final Logger logger = LoggerFactory.getLogger(MongoModify.class);
    private final OperationTransformer<T> transformer;
    private final MongoMetastoreContext<T> context;
    private final List<MongoOperation> operations = new ArrayList<MongoOperation>();

    public MongoModify(MetadataTypeValidator metadataTypeValidator, MongoMetastoreContext<T> context) {
        super(metadataTypeValidator);
        this.context = context;
        this.transformer = context.transformer().operation();
    }

    public void execute() {
        if (this.operations.isEmpty()) {
            return;
        }
        this.executeOperations(this.operations);
    }

    public void purge() {
        this.executeOperations(Collections.singletonList(this.transformer.toDeleteAll()));
    }

    protected void addOverwrite(List<T> units) {
        this.operations.addAll(this.transformer.toOverwrite(units));
    }

    protected void addDelete(Delete delete) {
        this.operations.add(this.transformer.toDelete(delete));
    }

    private void executeOperations(List<MongoOperation> operations) {
        ClientSession clientSession = this.context.client().startSession();
        String res = (String)clientSession.withTransaction(() -> {
            operations.forEach(o -> o.execute(this.context.table()));
            return String.format("executed %s operations", operations.size());
        });
        logger.debug(res);
    }
}

