/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import sqlline.BuiltInProperty;
import sqlline.SqlLine;

abstract class Rows
implements Iterator<Row> {
    static final Map<Character, String> ESCAPING_MAP = Rows.createEscapeMap();
    protected final SqlLine sqlLine;
    final ResultSetMetaData rsMeta;
    final Boolean[] primaryKeys;
    final Map<TableKey, Set<String>> tablePrimaryKeysCache = new HashMap<TableKey, Set<String>>();
    final NumberFormat numberFormat;
    final DateFormat dateFormat;
    final DateFormat timeFormat;
    final DateFormat timestampFormat;
    final String nullValue;
    final boolean escapeOutput;

    Rows(SqlLine sqlLine, ResultSet rs) throws SQLException {
        String pattern;
        this.sqlLine = sqlLine;
        this.rsMeta = rs.getMetaData();
        int count = this.rsMeta.getColumnCount();
        this.primaryKeys = new Boolean[count];
        if (sqlLine.getOpts().isDefault(BuiltInProperty.NUMBER_FORMAT)) {
            this.numberFormat = null;
        } else {
            pattern = sqlLine.getOpts().get(BuiltInProperty.NUMBER_FORMAT);
            this.numberFormat = new DecimalFormat(pattern, DecimalFormatSymbols.getInstance(Locale.ROOT));
        }
        if (sqlLine.getOpts().isDefault(BuiltInProperty.DATE_FORMAT)) {
            this.dateFormat = null;
        } else {
            pattern = sqlLine.getOpts().get(BuiltInProperty.DATE_FORMAT);
            this.dateFormat = new SimpleDateFormat(pattern, Locale.ROOT);
        }
        if (sqlLine.getOpts().isDefault(BuiltInProperty.TIME_FORMAT)) {
            this.timeFormat = null;
        } else {
            pattern = sqlLine.getOpts().get(BuiltInProperty.TIME_FORMAT);
            this.timeFormat = new SimpleDateFormat(pattern, Locale.ROOT);
        }
        if (sqlLine.getOpts().isDefault(BuiltInProperty.TIMESTAMP_FORMAT)) {
            this.timestampFormat = null;
        } else {
            pattern = sqlLine.getOpts().get(BuiltInProperty.TIMESTAMP_FORMAT);
            this.timestampFormat = new SimpleDateFormat(pattern, Locale.ROOT);
        }
        this.nullValue = sqlLine.getOpts().isDefault(BuiltInProperty.NULL_VALUE) ? null : sqlLine.getOpts().get(BuiltInProperty.NULL_VALUE);
        this.escapeOutput = sqlLine.getOpts().getEscapeOutput();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    abstract void normalizeWidths(int var1);

    boolean isPrimaryKey(int col) {
        if (this.primaryKeys[col] != null) {
            return this.primaryKeys[col];
        }
        try {
            String schema;
            int colNum = col + 1;
            String table = this.rsMeta.getTableName(colNum);
            if (table == null || table.length() == 0) {
                this.primaryKeys[col] = false;
                return this.primaryKeys[col];
            }
            String column = this.rsMeta.getColumnName(colNum);
            if (column == null || column.length() == 0) {
                this.primaryKeys[col] = false;
                return this.primaryKeys[col];
            }
            DatabaseMetaData dbMeta = this.sqlLine.getDatabaseConnection().meta;
            String catalog = dbMeta.getConnection().getCatalog();
            Set<String> tablePrimaryKeys = this.getTablePrimaryKeys(catalog, schema = this.rsMeta.getSchemaName(colNum), table);
            this.primaryKeys[col] = tablePrimaryKeys != null && tablePrimaryKeys.contains(column);
            return this.primaryKeys[col];
        }
        catch (SQLException e) {
            this.primaryKeys[col] = false;
            return this.primaryKeys[col];
        }
    }

    private static Map<Character, String> createEscapeMap() {
        HashMap<Character, String> map = new HashMap<Character, String>();
        map.put(Character.valueOf('\\'), "\\\\");
        map.put(Character.valueOf('\"'), "\\\"");
        map.put(Character.valueOf('\b'), "\\b");
        map.put(Character.valueOf('\f'), "\\f");
        map.put(Character.valueOf('\n'), "\\n");
        map.put(Character.valueOf('\r'), "\\r");
        map.put(Character.valueOf('\t'), "\\t");
        map.put(Character.valueOf('/'), "\\/");
        map.put(Character.valueOf('\u0000'), "\\u0000");
        map.put(Character.valueOf('\u0001'), "\\u0001");
        map.put(Character.valueOf('\u0002'), "\\u0002");
        map.put(Character.valueOf('\u0003'), "\\u0003");
        map.put(Character.valueOf('\u0004'), "\\u0004");
        map.put(Character.valueOf('\u0005'), "\\u0005");
        map.put(Character.valueOf('\u0006'), "\\u0006");
        map.put(Character.valueOf('\u0007'), "\\u0007");
        map.put(Character.valueOf('\u000b'), "\\u000B");
        map.put(Character.valueOf('\u000e'), "\\u000E");
        map.put(Character.valueOf('\u000f'), "\\u000F");
        map.put(Character.valueOf('\u0010'), "\\u0010");
        map.put(Character.valueOf('\u0011'), "\\u0011");
        map.put(Character.valueOf('\u0012'), "\\u0012");
        map.put(Character.valueOf('\u0013'), "\\u0013");
        map.put(Character.valueOf('\u0014'), "\\u0014");
        map.put(Character.valueOf('\u0015'), "\\u0015");
        map.put(Character.valueOf('\u0016'), "\\u0016");
        map.put(Character.valueOf('\u0017'), "\\u0017");
        map.put(Character.valueOf('\u0018'), "\\u0018");
        map.put(Character.valueOf('\u0019'), "\\u0019");
        map.put(Character.valueOf('\u001a'), "\\u001A");
        map.put(Character.valueOf('\u001b'), "\\u001B");
        map.put(Character.valueOf('\u001c'), "\\u001C");
        map.put(Character.valueOf('\u001d'), "\\u001D");
        map.put(Character.valueOf('\u001e'), "\\u001E");
        map.put(Character.valueOf('\u001f'), "\\u001F");
        return Collections.unmodifiableMap(map);
    }

    static String escapeControlSymbols(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        StringBuilder result = null;
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (Character.getType(ch) == 15) {
                if (result == null) {
                    result = new StringBuilder();
                    if (i != 0) {
                        result.append(value, 0, i);
                    }
                }
                result.append(ESCAPING_MAP.get(Character.valueOf(ch)));
                continue;
            }
            if (result == null) continue;
            result.append(ch);
        }
        return result == null ? value : result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> loadAndCachePrimaryKeysForTable(TableKey tableKey) {
        HashSet<String> primaryKeys = new HashSet<String>();
        try (ResultSet pks = this.sqlLine.getDatabaseConnection().meta.getPrimaryKeys(tableKey.catalog, tableKey.schema, tableKey.table);){
            while (pks.next()) {
                primaryKeys.add(pks.getString("COLUMN_NAME"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.tablePrimaryKeysCache.put(tableKey, primaryKeys);
        return primaryKeys;
    }

    private Set<String> getTablePrimaryKeys(String catalog, String schema, String table) {
        TableKey tableKey = new TableKey(catalog, schema, table);
        Set<String> primaryKeys = this.tablePrimaryKeysCache.get(tableKey);
        if (primaryKeys == null) {
            primaryKeys = this.loadAndCachePrimaryKeysForTable(tableKey);
        }
        return primaryKeys;
    }

    private static class TableKey {
        private final String catalog;
        private final String schema;
        private final String table;

        private TableKey(String catalog, String schema, String table) {
            this.catalog = catalog;
            this.schema = schema;
            this.table = table;
        }

        public int hashCode() {
            return (this.catalog == null ? 13 : this.catalog.hashCode()) + (this.schema == null ? 17 : this.schema.hashCode()) + (this.table == null ? 19 : this.table.hashCode());
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof TableKey && Objects.equals(this.catalog, ((TableKey)obj).catalog) && Objects.equals(this.schema, ((TableKey)obj).schema) && Objects.equals(this.table, ((TableKey)obj).table);
        }

        public String toString() {
            return (this.catalog == null ? "" : this.catalog) + ":" + (this.schema == null ? "" : this.schema) + ":" + (this.table == null ? "" : this.table);
        }
    }

    class Row {
        final String[] values;
        final boolean isMeta;
        protected boolean deleted;
        protected boolean inserted;
        protected boolean updated;
        protected int[] sizes;

        Row(int size) throws SQLException {
            this(size, this$0.rsMeta::getColumnLabel);
        }

        Row(int size, CheckedFunction<Integer, String> toValue) throws SQLException {
            this.isMeta = true;
            this.values = new String[size];
            this.sizes = new int[size];
            for (int i = 0; i < size; ++i) {
                this.values[i] = toValue.apply(i + 1);
                this.sizes[i] = this.values[i] == null ? 1 : Arrays.stream(this.values[i].split("\n")).map(String::length).max(Integer::compare).orElse(1);
            }
            this.deleted = false;
            this.updated = false;
            this.inserted = false;
        }

        Row(int size, ResultSet rs) throws SQLException {
            this.isMeta = false;
            this.values = new String[size];
            this.sizes = new int[size];
            try {
                this.deleted = rs.rowDeleted();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.updated = rs.rowUpdated();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.inserted = rs.rowInserted();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            for (int i = 0; i < size; ++i) {
                switch (rs.getMetaData().getColumnType(i + 1)) {
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        this.setFormat(rs.getObject(i + 1), Rows.this.numberFormat, i);
                        break;
                    }
                    case -8: 
                    case -7: 
                    case 2000: 
                    case 2002: 
                    case 2004: 
                    case 2005: 
                    case 2006: 
                    case 2009: 
                    case 2011: {
                        this.setFormat(rs.getObject(i + 1), null, i);
                        break;
                    }
                    case 92: {
                        this.setFormat(rs.getObject(i + 1), Rows.this.timeFormat, i);
                        break;
                    }
                    case 91: {
                        this.setFormat(rs.getObject(i + 1), Rows.this.dateFormat, i);
                        break;
                    }
                    case 93: {
                        this.setFormat(rs.getObject(i + 1), Rows.this.timestampFormat, i);
                        break;
                    }
                    default: {
                        this.values[i] = rs.getString(i + 1);
                    }
                }
                this.values[i] = this.values[i] == null ? Rows.this.nullValue : (Rows.this.escapeOutput ? Rows.escapeControlSymbols(this.values[i]) : this.values[i]);
                this.sizes[i] = this.values[i] == null ? 1 : Arrays.stream(this.values[i].split("\n")).map(String::length).max(Integer::compare).orElse(1);
            }
        }

        private void setFormat(Object o, Format format, int i) {
            this.values[i] = o == null ? String.valueOf(Rows.this.nullValue) : (format != null ? format.format(o) : o.toString());
        }
    }

    @FunctionalInterface
    static interface CheckedFunction<T, R> {
        public R apply(T var1) throws SQLException;
    }
}

