/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import sqlline.SqlLine;
import sqlline.SqlLineOpts;

class ConnectionConfigParser {
    public static final String GLOBAL_CONFIG_NAME = "global-conf";
    public static final File DEFAULT_CONNECTION_CONFIG_FILE = new File(SqlLineOpts.saveDir(), "configuration");
    private static final String DEFAULT_CONNECTION_CONFIG_LOCATION = DEFAULT_CONNECTION_CONFIG_FILE.getAbsolutePath();
    private static final String SEPARATOR = ":";
    private static final char COMMENT_START = '#';
    private final SqlLine sqlLine;
    private final Map<String, Properties> connections = new HashMap<String, Properties>();

    ConnectionConfigParser(SqlLine sqlLine) {
        this.sqlLine = sqlLine;
    }

    Properties getConnectionProperties(String connectionName) {
        if (this.connections.isEmpty()) {
            String connectionConfig = this.sqlLine.getOpts().getConnectionConfig();
            if (connectionConfig == null || connectionConfig.isEmpty()) {
                Path connectionConfigLocation = Paths.get(DEFAULT_CONNECTION_CONFIG_LOCATION, new String[0]);
                if (!Files.exists(connectionConfigLocation, new LinkOption[0]) || Files.isDirectory(connectionConfigLocation, new LinkOption[0])) {
                    return null;
                }
                this.readFromFile(connectionConfigLocation);
            } else {
                this.readFromFile(Paths.get(connectionConfig, new String[0]));
            }
        }
        return this.connections.get(connectionName);
    }

    void resetConnectionProperties() {
        this.connections.clear();
    }

    private void readFromFile(Path path) {
        if (!Files.exists(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0])) {
            this.sqlLine.error(this.sqlLine.loc("no-file", path.toAbsolutePath()));
            return;
        }
        int minOffset = Integer.MAX_VALUE;
        String connectionName = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path.toFile()), StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.isEmpty()) continue;
                int offset = 0;
                while (Character.isWhitespace(line.charAt(offset))) {
                    ++offset;
                }
                if (line.charAt(offset) == '#' || line.charAt(offset) == ':' || !line.contains(SEPARATOR)) continue;
                int sepIndex = line.indexOf(SEPARATOR);
                String name = line.substring(0, sepIndex).trim();
                if (minOffset >= offset) {
                    connectionName = name;
                    this.connections.put(connectionName, new Properties());
                    minOffset = offset;
                    continue;
                }
                String value = line.substring(sepIndex + SEPARATOR.length()).trim();
                if (!value.isEmpty() && value.charAt(0) == '#') {
                    value = "";
                }
                this.connections.get(connectionName).setProperty(name, value);
            }
        }
        catch (Exception e) {
            this.sqlLine.error(e);
        }
    }
}

