/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import sqlline.Application;
import sqlline.SqlLineOpts;
import sqlline.SqlLineProperty;

public enum BuiltInProperty implements SqlLineProperty
{
    AUTO_COMMIT("autoCommit", SqlLineProperty.Type.BOOLEAN, true),
    AUTO_PAIRING("autoPairing", SqlLineProperty.Type.BOOLEAN, true),
    AUTO_RESIZE("autoResize", SqlLineProperty.Type.BOOLEAN, false),
    AUTO_SAVE("autoSave", SqlLineProperty.Type.BOOLEAN, false),
    COLOR_SCHEME("colorScheme", SqlLineProperty.Type.STRING, "default", true, false, new Application().getName2HighlightStyle().keySet()),
    COLOR("color", SqlLineProperty.Type.BOOLEAN, false),
    CONFIRM("confirm", SqlLineProperty.Type.BOOLEAN, false),
    CONFIRM_PATTERN("confirmPattern", SqlLineProperty.Type.STRING, "^(?i:(DROP|DELETE))"),
    CONNECT_INTERACTION_MODE("connectInteractionMode", SqlLineProperty.Type.STRING, new Application().getDefaultInteractiveMode(), true, false, new HashSet<String>(new Application().getConnectInteractiveModes())),
    CONNECTION_CONFIG("connectionConfig", SqlLineProperty.Type.FILE_PATH, ""),
    CSV_DELIMITER("csvDelimiter", SqlLineProperty.Type.STRING, ","),
    CSV_QUOTE_CHARACTER("csvQuoteCharacter", SqlLineProperty.Type.CHAR, Character.valueOf('\'')),
    DATE_FORMAT("dateFormat", SqlLineProperty.Type.STRING, "default"),
    ESCAPE_OUTPUT("escapeOutput", SqlLineProperty.Type.BOOLEAN, false),
    FAST_CONNECT("fastConnect", SqlLineProperty.Type.BOOLEAN, true),
    FORCE("force", SqlLineProperty.Type.BOOLEAN, false),
    HEADER_INTERVAL("headerInterval", SqlLineProperty.Type.INTEGER, 100),
    HISTORY_FILE("historyFile", SqlLineProperty.Type.FILE_PATH, new File(SqlLineOpts.saveDir(), "history").getAbsolutePath()),
    HISTORY_FLAGS("historyFlags", SqlLineProperty.Type.STRING, "-d"),
    INCREMENTAL("incremental", SqlLineProperty.Type.BOOLEAN, false),
    INCREMENTAL_BUFFER_ROWS("incrementalBufferRows", SqlLineProperty.Type.INTEGER, 1000),
    ISOLATION("isolation", SqlLineProperty.Type.STRING, "TRANSACTION_REPEATABLE_READ", true, false, new HashSet<String>(new Application().getIsolationLevels())),
    KEEP_SEMICOLON("keepSemicolon", SqlLineProperty.Type.BOOLEAN, false),
    LIVE_TEMPLATES("liveTemplates", SqlLineProperty.Type.FILE_PATH, ""),
    MAX_COLUMN_WIDTH("maxColumnWidth", SqlLineProperty.Type.INTEGER, -1),
    MAX_HEIGHT("maxHeight", SqlLineProperty.Type.INTEGER, 80, false, false, null),
    MAX_WIDTH("maxWidth", SqlLineProperty.Type.INTEGER, 80, false, false, null),
    MAX_HISTORY_ROWS("maxHistoryRows", SqlLineProperty.Type.INTEGER, 500),
    MAX_HISTORY_FILE_ROWS("maxHistoryFileRows", SqlLineProperty.Type.INTEGER, 10000),
    MODE("mode", SqlLineProperty.Type.STRING, "emacs", true, false, new HashSet<String>(Arrays.asList("emacs", "vi"))),
    NUMBER_FORMAT("numberFormat", SqlLineProperty.Type.STRING, "default"),
    NULL_VALUE("nullValue", SqlLineProperty.Type.STRING, "default"),
    SILENT("silent", SqlLineProperty.Type.BOOLEAN, false),
    OUTPUT_FORMAT("outputFormat", SqlLineProperty.Type.STRING, "table"),
    TABLE_STYLE("tableStyle", SqlLineProperty.Type.STRING, "default", true, false, new Application().getName2TableOutputFormatStyle().keySet()),
    PROMPT("prompt", SqlLineProperty.Type.STRING, "sqlline> "),
    PROMPT_SCRIPT("promptScript", SqlLineProperty.Type.STRING, ""),
    PROPERTIES_FILE("propertiesFile", SqlLineProperty.Type.FILE_PATH, new File(SqlLineOpts.saveDir(), "sqlline.properties").getAbsolutePath()),
    READ_ONLY("readOnly", SqlLineProperty.Type.BOOLEAN, false),
    RIGHT_PROMPT("rightPrompt", SqlLineProperty.Type.STRING, ""),
    ROW_LIMIT("rowLimit", SqlLineProperty.Type.INTEGER, 0),
    SHOW_ELAPSED_TIME("showElapsedTime", SqlLineProperty.Type.BOOLEAN, true),
    SCRIPT_ENGINE("scriptEngine", SqlLineProperty.Type.STRING, "nashorn", true, false, new Application().getAvailableScriptEngineNames()),
    SHOW_COMPLETION_DESCR("showCompletionDesc", SqlLineProperty.Type.BOOLEAN, true),
    SHOW_HEADER("showHeader", SqlLineProperty.Type.BOOLEAN, true),
    SHOW_LINE_NUMBERS("showLineNumbers", SqlLineProperty.Type.BOOLEAN, false),
    SHOW_NESTED_ERRS("showNestedErrs", SqlLineProperty.Type.BOOLEAN, false),
    SHOW_TYPES("showTypes", SqlLineProperty.Type.BOOLEAN, false),
    SHOW_WARNINGS("showWarnings", SqlLineProperty.Type.BOOLEAN, true),
    STRICT_JDBC("strictJdbc", SqlLineProperty.Type.BOOLEAN, false),
    TIME_FORMAT("timeFormat", SqlLineProperty.Type.STRING, "default"),
    TIMEOUT("timeout", SqlLineProperty.Type.INTEGER, -1),
    TIMESTAMP_FORMAT("timestampFormat", SqlLineProperty.Type.STRING, "default"),
    TRIM_SCRIPTS("trimScripts", SqlLineProperty.Type.BOOLEAN, true),
    USE_LINE_CONTINUATION("useLineContinuation", SqlLineProperty.Type.BOOLEAN, true),
    VERBOSE("verbose", SqlLineProperty.Type.BOOLEAN, false),
    VERSION("version", SqlLineProperty.Type.STRING, new Application().getVersion(), false, true, null);

    private final String propertyName;
    private final SqlLineProperty.Type type;
    private final Object defaultValue;
    private final boolean couldBeStored;
    private final boolean isReadOnly;
    private final Set<String> availableValues;

    private BuiltInProperty(String propertyName, SqlLineProperty.Type type, Object defaultValue) {
        this(propertyName, type, defaultValue, true, false, null);
    }

    private BuiltInProperty(String propertyName, SqlLineProperty.Type type, Object defaultValue, boolean couldBeStored, boolean isReadOnly, Set<String> availableValues) {
        this.propertyName = propertyName;
        this.type = type;
        this.defaultValue = defaultValue;
        this.isReadOnly = isReadOnly;
        this.couldBeStored = couldBeStored;
        this.availableValues = availableValues == null ? Collections.emptySet() : Collections.unmodifiableSet(availableValues);
    }

    @Override
    public String propertyName() {
        return this.propertyName;
    }

    @Override
    public Object defaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public boolean couldBeStored() {
        return this.couldBeStored;
    }

    @Override
    public SqlLineProperty.Type type() {
        return this.type;
    }

    @Override
    public Set<String> getAvailableValues() {
        return this.availableValues;
    }

    public static SqlLineProperty valueOf(String propertyName, boolean ignoreCase) {
        for (BuiltInProperty property : BuiltInProperty.values()) {
            if (!BuiltInProperty.compare(propertyName, property.propertyName(), ignoreCase)) continue;
            return property;
        }
        return null;
    }

    private static boolean compare(String s0, String s1, boolean ignoreCase) {
        return ignoreCase ? s1.equalsIgnoreCase(s0) : s1.equals(s0);
    }
}

