/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util.regex;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.List;
import java.util.Map;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.base.Function;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.phoenix.util.UpsertExecutor;
import org.apache.phoenix.util.json.JsonUpsertExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexUpsertExecutor
extends JsonUpsertExecutor {
    protected static final Logger LOGGER = LoggerFactory.getLogger(RegexUpsertExecutor.class);

    @VisibleForTesting
    protected RegexUpsertExecutor(Connection conn, List<ColumnInfo> columnInfoList, PreparedStatement stmt, UpsertExecutor.UpsertListener<Map<?, ?>> upsertListener) {
        super(conn, columnInfoList, stmt, upsertListener);
    }

    public RegexUpsertExecutor(Connection conn, String tableName, List<ColumnInfo> columnInfoList, UpsertExecutor.UpsertListener<Map<?, ?>> upsertListener) {
        super(conn, tableName, columnInfoList, upsertListener);
    }

    @Override
    protected void execute(Map<?, ?> record) {
        int fieldIndex = 0;
        String colName = null;
        try {
            if (record.size() < this.conversionFunctions.size()) {
                String message = String.format("Input record does not have enough values based on regex (has %d, but needs %d)", record.size(), this.conversionFunctions.size());
                throw new IllegalArgumentException(message);
            }
            for (fieldIndex = 0; fieldIndex < this.conversionFunctions.size(); ++fieldIndex) {
                colName = ((ColumnInfo)this.columnInfos.get(fieldIndex)).getColumnName();
                Object sqlValue = ((Function)this.conversionFunctions.get(fieldIndex)).apply(record.get(colName));
                if (sqlValue != null) {
                    this.preparedStatement.setObject(fieldIndex + 1, sqlValue);
                    continue;
                }
                this.preparedStatement.setNull(fieldIndex + 1, ((PDataType)this.dataTypes.get(fieldIndex)).getSqlType());
            }
            this.preparedStatement.execute();
            this.upsertListener.upsertDone(++this.upsertCount);
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Error on record " + record + ", fieldIndex " + fieldIndex + ", colName " + colName, (Throwable)e);
            }
            this.upsertListener.errorOnRecord(record, new Exception("fieldIndex: " + fieldIndex + ", colName " + colName, e));
        }
    }
}

