/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.PhoenixKeyValueUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TrustedByteArrayOutputStream;

public class TupleUtil {
    private TupleUtil() {
    }

    public static boolean equals(Tuple t1, Tuple t2, ImmutableBytesWritable ptr) {
        t1.getKey(ptr);
        byte[] buf = ptr.get();
        int offset = ptr.getOffset();
        int length = ptr.getLength();
        t2.getKey(ptr);
        return Bytes.compareTo((byte[])buf, (int)offset, (int)length, (byte[])ptr.get(), (int)ptr.getOffset(), (int)ptr.getLength()) == 0;
    }

    public static int compare(Tuple t1, Tuple t2, ImmutableBytesWritable ptr) {
        return TupleUtil.compare(t1, t2, ptr, 0);
    }

    public static int compare(Tuple t1, Tuple t2, ImmutableBytesWritable ptr, int keyOffset) {
        t1.getKey(ptr);
        byte[] buf = ptr.get();
        int offset = ptr.getOffset() + keyOffset;
        int length = ptr.getLength() - keyOffset;
        t2.getKey(ptr);
        return Bytes.compareTo((byte[])buf, (int)offset, (int)length, (byte[])ptr.get(), (int)(ptr.getOffset() + keyOffset), (int)(ptr.getLength() - keyOffset));
    }

    public static void getAggregateValue(Tuple r, ImmutableBytesWritable ptr) {
        Cell kv;
        if (r.size() == 1 && Bytes.compareTo((byte[])QueryConstants.SINGLE_COLUMN_FAMILY, (int)0, (int)QueryConstants.SINGLE_COLUMN_FAMILY.length, (byte[])(kv = r.getValue(0)).getFamilyArray(), (int)kv.getFamilyOffset(), (int)kv.getFamilyLength()) == 0 && Bytes.compareTo((byte[])QueryConstants.SINGLE_COLUMN, (int)0, (int)QueryConstants.SINGLE_COLUMN.length, (byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength()) == 0) {
            ptr.set(kv.getValueArray(), kv.getValueOffset(), kv.getValueLength());
            return;
        }
        throw new IllegalStateException("Expected single, aggregated KeyValue from coprocessor, but instead received " + r + ". Ensure aggregating coprocessors are loaded correctly on server");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImmutableBytesPtr getConcatenatedValue(Tuple result, List<Expression> expressions) throws IOException {
        ImmutableBytesPtr value = new ImmutableBytesPtr(ByteUtil.EMPTY_BYTE_ARRAY);
        Expression expression = expressions.get(0);
        boolean evaluated = expression.evaluate(result, value);
        if (expressions.size() == 1) {
            if (!evaluated) {
                value.set(ByteUtil.EMPTY_BYTE_ARRAY);
            }
            return value;
        }
        try (TrustedByteArrayOutputStream output = new TrustedByteArrayOutputStream(value.getLength() * expressions.size());){
            if (evaluated) {
                output.write(value.get(), value.getOffset(), value.getLength());
            }
            for (int i = 1; i < expressions.size(); ++i) {
                if (!expression.getDataType().isFixedWidth()) {
                    output.write(SchemaUtil.getSeparatorByte(true, value.getLength() == 0, expression));
                }
                if ((expression = expressions.get(i)).evaluate(result, value)) {
                    output.write(value.get(), value.getOffset(), value.getLength());
                    continue;
                }
                if (i >= expressions.size() - 1 || !expression.getDataType().isFixedWidth()) continue;
                throw new DoNotRetryIOException("Non terminating null value found for fixed width expression (" + expression + ") in row: " + result);
            }
            if (!expression.getDataType().isFixedWidth() && SchemaUtil.getSeparatorByte(true, value.getLength() == 0, expression) == QueryConstants.DESC_SEPARATOR_BYTE) {
                output.write(QueryConstants.DESC_SEPARATOR_BYTE);
            }
            byte[] outputBytes = output.getBuffer();
            value.set(outputBytes, 0, output.size());
            ImmutableBytesPtr immutableBytesPtr = value;
            return immutableBytesPtr;
        }
    }

    public static int write(Tuple result, DataOutput out) throws IOException {
        KeyValue kv;
        int i;
        int size = 0;
        for (i = 0; i < result.size(); ++i) {
            kv = PhoenixKeyValueUtil.maybeCopyCell(result.getValue(i));
            size += kv.getLength();
            size += 4;
        }
        WritableUtils.writeVInt((DataOutput)out, (int)size);
        for (i = 0; i < result.size(); ++i) {
            kv = PhoenixKeyValueUtil.maybeCopyCell(result.getValue(i));
            out.writeInt(kv.getLength());
            out.write(kv.getBuffer(), kv.getOffset(), kv.getLength());
        }
        return size;
    }
}

