/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.sql.SQLException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.schema.SequenceInfo;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.math.LongMath;

public class SequenceUtil {
    public static final long DEFAULT_NUM_SLOTS_TO_ALLOCATE = 1L;

    public static boolean checkIfLimitReached(long currentValue, long minValue, long maxValue, long incrementBy, long cacheSize, long numToAllocate) {
        long nextValue = 0L;
        boolean increasingSeq = incrementBy > 0L;
        try {
            long incrementValue = SequenceUtil.isBulkAllocation(numToAllocate) ? LongMath.checkedMultiply((long)incrementBy, (long)numToAllocate) : LongMath.checkedMultiply((long)incrementBy, (long)cacheSize);
            nextValue = LongMath.checkedAdd((long)currentValue, (long)incrementValue);
        }
        catch (ArithmeticException e) {
            return true;
        }
        return increasingSeq && nextValue > maxValue || !increasingSeq && nextValue < minValue;
    }

    public static boolean checkIfLimitReached(long currentValue, long minValue, long maxValue, long incrementBy, long cacheSize) throws SQLException {
        return SequenceUtil.checkIfLimitReached(currentValue, minValue, maxValue, incrementBy, cacheSize, 1L);
    }

    public static boolean checkIfLimitReached(SequenceInfo info) throws SQLException {
        return SequenceUtil.checkIfLimitReached(info.sequenceValue, info.minValue, info.maxValue, info.incrementBy, info.cacheSize, 1L);
    }

    public static boolean isBulkAllocation(long numToAllocate) {
        Preconditions.checkArgument((numToAllocate > 0L ? 1 : 0) != 0);
        return numToAllocate > 1L;
    }

    public static boolean isCycleAllowed(long numToAllocate) {
        return !SequenceUtil.isBulkAllocation(numToAllocate);
    }

    public static SQLException getException(String schemaName, String tableName, SQLExceptionCode code) {
        return new SQLExceptionInfo.Builder(code).setSchemaName(schemaName).setTableName(tableName).build().buildException();
    }

    public static SQLExceptionCode getLimitReachedErrorCode(boolean increasingSeq) {
        SQLExceptionCode code = increasingSeq ? SQLExceptionCode.SEQUENCE_VAL_REACHED_MAX_VALUE : SQLExceptionCode.SEQUENCE_VAL_REACHED_MIN_VALUE;
        return code;
    }
}

