/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compat.hbase.CompatUtil;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.schema.TableRef;

public class PhoenixKeyValueUtil {
    private PhoenixKeyValueUtil() {
    }

    public static Cell newKeyValue(byte[] key, byte[] cf, byte[] cq, long ts, byte[] value, int valueOffset, int valueLength) {
        return CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(key).setFamily(cf).setQualifier(cq).setTimestamp(ts).setType(Cell.Type.Put).setValue(value, valueOffset, valueLength).build();
    }

    public static Cell newKeyValue(ImmutableBytesWritable key, byte[] cf, byte[] cq, long ts, byte[] value, int valueOffset, int valueLength) {
        return CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(key.get(), key.getOffset(), key.getLength()).setFamily(cf).setQualifier(cq).setTimestamp(ts).setType(Cell.Type.Put).setValue(value, valueOffset, valueLength).build();
    }

    public static Cell newKeyValue(byte[] key, int keyOffset, int keyLength, byte[] cf, byte[] cq, long ts, byte[] value, int valueOffset, int valueLength) {
        return CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(key, keyOffset, keyLength).setFamily(cf).setQualifier(cq).setTimestamp(ts).setType(Cell.Type.Put).setValue(value, valueOffset, valueLength).build();
    }

    public static Cell newKeyValue(byte[] key, int keyOffset, int keyLength, byte[] cf, int cfOffset, int cfLength, byte[] cq, int cqOffset, int cqLength, long ts, byte[] value, int valueOffset, int valueLength, Cell.Type type) {
        return CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(key, keyOffset, keyLength).setFamily(cf, cfOffset, cfLength).setQualifier(cq, cqOffset, cqLength).setTimestamp(ts).setValue(value, valueOffset, valueLength).setType(type).build();
    }

    public static Cell newKeyValue(byte[] key, byte[] cf, byte[] cq, long ts, byte[] value) {
        return PhoenixKeyValueUtil.newKeyValue(key, cf, cq, ts, value, 0, value.length);
    }

    public static Cell getColumnLatest(KeyValueBuilder kvBuilder, List<Cell> kvs, byte[] family, byte[] qualifier) {
        if (kvs.size() == 0) {
            return null;
        }
        assert (CellUtil.matchingRows((Cell)kvs.get(0), (Cell)kvs.get(kvs.size() - 1)));
        SearchComparator comp = new SearchComparator(kvBuilder, family, qualifier);
        int pos = Collections.binarySearch(kvs, null, comp);
        if (pos < 0 || pos == kvs.size()) {
            return null;
        }
        return kvs.get(pos);
    }

    public static Cell getColumnLatest(KeyValueBuilder kvBuilder, Cell[] kvs, byte[] family, byte[] qualifier) {
        if (kvs.length == 0) {
            return null;
        }
        assert (CellUtil.matchingRows((Cell)kvs[0], (Cell)kvs[kvs.length - 1]));
        SearchComparator comp = new SearchComparator(kvBuilder, family, qualifier);
        int pos = Arrays.binarySearch(kvs, null, comp);
        if (pos < 0 || pos == kvs.length) {
            return null;
        }
        return kvs[pos];
    }

    public static long calculateMutationDiskSize(Mutation m) {
        long size = 0L;
        for (Map.Entry entry : m.getFamilyCellMap().entrySet()) {
            for (Cell c : (List)entry.getValue()) {
                size += (long)CompatUtil.getCellSerializedSize((Cell)c);
            }
        }
        return size;
    }

    public static long getEstimatedRowMutationSize(Map<TableRef, MutationState.MultiRowMutationState> tableMutationMap) {
        long size = 0L;
        for (Map.Entry<TableRef, MutationState.MultiRowMutationState> tableEntry : tableMutationMap.entrySet()) {
            size += PhoenixKeyValueUtil.calculateMultiRowMutationSize(tableEntry.getValue());
        }
        return size;
    }

    public static long getEstimatedRowMutationSizeWithBatch(Map<TableRef, List<MutationState.MultiRowMutationState>> tableMutationMap) {
        long size = 0L;
        for (Map.Entry<TableRef, List<MutationState.MultiRowMutationState>> tableEntry : tableMutationMap.entrySet()) {
            for (MutationState.MultiRowMutationState batch : tableEntry.getValue()) {
                size += PhoenixKeyValueUtil.calculateMultiRowMutationSize(batch);
            }
        }
        return size;
    }

    public static KeyValue maybeCopyCell(Cell c) {
        if (c == null) {
            return null;
        }
        if (c instanceof KeyValue) {
            return (KeyValue)c;
        }
        return KeyValueUtil.copyToNewKeyValue((Cell)c);
    }

    private static long calculateMultiRowMutationSize(MutationState.MultiRowMutationState mutations) {
        long size = 0L;
        for (Map.Entry<ImmutableBytesPtr, MutationState.RowMutationState> rowEntry : mutations.entrySet()) {
            size += PhoenixKeyValueUtil.calculateRowMutationSize(rowEntry);
        }
        return size;
    }

    private static long calculateRowMutationSize(Map.Entry<ImmutableBytesPtr, MutationState.RowMutationState> rowEntry) {
        int rowLength = rowEntry.getKey().getLength();
        long colValuesLength = rowEntry.getValue().calculateEstimatedSize();
        return (long)rowLength + colValuesLength;
    }

    public static void setTimestamp(Mutation m, long timestamp) {
        byte[] tsBytes = Bytes.toBytes((long)timestamp);
        for (List family : m.getFamilyCellMap().values()) {
            List familyKVs = KeyValueUtil.ensureKeyValues((List)family);
            for (KeyValue kv : familyKVs) {
                int tsOffset = kv.getTimestampOffset();
                System.arraycopy(tsBytes, 0, kv.getBuffer(), tsOffset, 8);
            }
        }
    }

    private static class SearchComparator
    implements Comparator<Cell> {
        private final KeyValueBuilder kvBuilder;
        private final byte[] family;
        private final byte[] qualifier;

        public SearchComparator(KeyValueBuilder kvBuilder, byte[] f, byte[] q) {
            this.kvBuilder = kvBuilder;
            this.family = f;
            this.qualifier = q;
        }

        @Override
        public int compare(Cell l, Cell ignored) {
            assert (ignored == null);
            int val = this.kvBuilder.compareFamily(l, this.family, 0, this.family.length);
            if (val != 0) {
                return val;
            }
            return this.kvBuilder.compareQualifier(l, this.qualifier, 0, this.qualifier.length);
        }
    }
}

