/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import javax.annotation.Nullable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.jdbc.PhoenixConnection;

public class LogUtil {
    private LogUtil() {
    }

    public static String addCustomAnnotations(@Nullable String logLine, @Nullable PhoenixConnection con) {
        if (con == null || con.getCustomTracingAnnotations() == null || con.getCustomTracingAnnotations().isEmpty()) {
            return logLine;
        }
        return LogUtil.customAnnotationsToString(con) + ' ' + logLine;
    }

    public static String addCustomAnnotations(@Nullable String logLine, @Nullable byte[] annotations) {
        if (annotations == null) {
            return logLine;
        }
        return Bytes.toString((byte[])annotations) + ' ' + logLine;
    }

    public static String customAnnotationsToString(@Nullable PhoenixConnection con) {
        if (con == null || con.getCustomTracingAnnotations() == null || con.getCustomTracingAnnotations().isEmpty()) {
            return null;
        }
        return con.getCustomTracingAnnotations().toString();
    }

    public static String getCallerStackTrace() {
        StackTraceElement[] st = Thread.currentThread().getStackTrace();
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement element : st) {
            sb.append(element.toString());
            sb.append("\n");
        }
        return sb.toString();
    }
}

