/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.NavigableSet;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.expression.DelegateExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.util.ScanUtil;

public class EncodedColumnsUtil {
    public static boolean usesEncodedColumnNames(PTable table) {
        return EncodedColumnsUtil.usesEncodedColumnNames(table.getEncodingScheme());
    }

    public static boolean usesEncodedColumnNames(PTable.QualifierEncodingScheme encodingScheme) {
        return encodingScheme != null && encodingScheme != PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS;
    }

    public static void setColumns(PColumn column, PTable table, Scan scan) {
        if (table.getImmutableStorageScheme() == PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS) {
            scan.addFamily(column.getFamilyName().getBytes());
        } else if (column.getColumnQualifierBytes() != null) {
            scan.addColumn(column.getFamilyName().getBytes(), column.getColumnQualifierBytes());
        }
    }

    public static boolean useNewValueColumnQualifier(Scan s) {
        return s.getAttribute("_UseNewValueColumnQualifier") != null;
    }

    public static PTable.QualifierEncodingScheme getQualifierEncodingScheme(Scan s) {
        return s.getAttribute("_QualifierEncodingScheme") == null ? PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS : PTable.QualifierEncodingScheme.fromSerializedValue(s.getAttribute("_QualifierEncodingScheme")[0]);
    }

    public static PTable.ImmutableStorageScheme getImmutableStorageScheme(Scan s) {
        return s.getAttribute("_ImmutableStorageEncodingScheme") == null ? PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN : PTable.ImmutableStorageScheme.fromSerializedValue(s.getAttribute("_ImmutableStorageEncodingScheme")[0]);
    }

    public static Pair<byte[], byte[]> getEmptyKeyValueInfo(PTable table) {
        return EncodedColumnsUtil.usesEncodedColumnNames(table) ? new Pair((Object)QueryConstants.ENCODED_EMPTY_COLUMN_BYTES, (Object)QueryConstants.ENCODED_EMPTY_COLUMN_VALUE_BYTES) : new Pair((Object)QueryConstants.EMPTY_COLUMN_BYTES, (Object)QueryConstants.EMPTY_COLUMN_VALUE_BYTES);
    }

    public static Pair<byte[], byte[]> getEmptyKeyValueInfo(boolean usesEncodedColumnNames) {
        return usesEncodedColumnNames ? new Pair((Object)QueryConstants.ENCODED_EMPTY_COLUMN_BYTES, (Object)QueryConstants.ENCODED_EMPTY_COLUMN_VALUE_BYTES) : new Pair((Object)QueryConstants.EMPTY_COLUMN_BYTES, (Object)QueryConstants.EMPTY_COLUMN_VALUE_BYTES);
    }

    public static Pair<byte[], byte[]> getEmptyKeyValueInfo(PTable.QualifierEncodingScheme encodingScheme) {
        return EncodedColumnsUtil.usesEncodedColumnNames(encodingScheme) ? new Pair((Object)QueryConstants.ENCODED_EMPTY_COLUMN_BYTES, (Object)QueryConstants.ENCODED_EMPTY_COLUMN_VALUE_BYTES) : new Pair((Object)QueryConstants.EMPTY_COLUMN_BYTES, (Object)QueryConstants.EMPTY_COLUMN_VALUE_BYTES);
    }

    public static Pair<Integer, Integer> getMinMaxQualifiersFromScan(Scan scan) {
        byte[] maxQualifier;
        Integer minQ = null;
        Integer maxQ = null;
        byte[] minQualifier = scan.getAttribute("_MinQualifier");
        if (minQualifier != null) {
            minQ = Bytes.toInt((byte[])minQualifier);
        }
        if ((maxQualifier = scan.getAttribute("_MaxQualifier")) != null) {
            maxQ = Bytes.toInt((byte[])maxQualifier);
        }
        if (minQualifier == null) {
            return null;
        }
        return new Pair((Object)minQ, (Object)maxQ);
    }

    public static boolean useEncodedQualifierListOptimization(PTable table, Scan scan) {
        return !scan.isRaw() && table.getColumnFamilies().size() == 1 && table.getImmutableStorageScheme() != null && table.getImmutableStorageScheme() == PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN && EncodedColumnsUtil.usesEncodedColumnNames(table) && !table.isTransactional() && !ScanUtil.hasDynamicColumns(table);
    }

    public static boolean useQualifierAsIndex(Pair<Integer, Integer> minMaxQualifiers) {
        return minMaxQualifiers != null;
    }

    public static Pair<Integer, Integer> setQualifiersForColumnsInFamily(PTable table, String cf, NavigableSet<byte[]> qualifierSet) throws ColumnFamilyNotFoundException {
        PTable.QualifierEncodingScheme encodingScheme = table.getEncodingScheme();
        Preconditions.checkArgument((encodingScheme != PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS ? 1 : 0) != 0);
        Collection<PColumn> columns = table.getColumnFamily(cf).getColumns();
        if (columns.size() > 0) {
            int[] qualifiers = new int[columns.size()];
            int i = 0;
            for (PColumn col : columns) {
                qualifierSet.add(col.getColumnQualifierBytes());
                qualifiers[i++] = encodingScheme.decode(col.getColumnQualifierBytes());
            }
            Arrays.sort(qualifiers);
            return new Pair((Object)qualifiers[0], (Object)qualifiers[qualifiers.length - 1]);
        }
        return null;
    }

    public static byte[] getColumnQualifierBytes(String columnName, Integer numberBasedQualifier, PTable table, boolean isPk) {
        PTable.QualifierEncodingScheme encodingScheme = table.getEncodingScheme();
        return EncodedColumnsUtil.getColumnQualifierBytes(columnName, numberBasedQualifier, encodingScheme, isPk);
    }

    public static byte[] getColumnQualifierBytes(String columnName, Integer numberBasedQualifier, PTable.QualifierEncodingScheme encodingScheme, boolean isPk) {
        if (isPk) {
            return null;
        }
        if (encodingScheme == null || encodingScheme == PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS) {
            return Bytes.toBytes((String)columnName);
        }
        return encodingScheme.encode(numberBasedQualifier);
    }

    public static Expression[] createColumnExpressionArray(int maxEncodedColumnQualifier) {
        int numElements = maxEncodedColumnQualifier - 11 + 2;
        Object[] colValues = new Expression[numElements];
        Arrays.fill(colValues, new DelegateExpression(LiteralExpression.newConstant(null)){

            @Override
            public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
                return false;
            }
        });
        colValues[0] = LiteralExpression.newConstant(QueryConstants.EMPTY_COLUMN_VALUE_BYTES);
        return colValues;
    }

    public static boolean isReservedColumnQualifier(int number) {
        if (number < 0) {
            throw new IllegalArgumentException("Negative column qualifier" + number + " not allowed ");
        }
        return number < 11;
    }

    public static boolean isPossibleToUseEncodedCQFilter(PTable.QualifierEncodingScheme encodingScheme, PTable.ImmutableStorageScheme storageScheme) {
        return EncodedColumnsUtil.usesEncodedColumnNames(encodingScheme) && storageScheme == PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN;
    }
}

