/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.io.File;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.thirdparty.com.google.common.base.Charsets;
import org.apache.phoenix.thirdparty.com.google.common.base.Joiner;
import org.apache.phoenix.thirdparty.com.google.common.base.Throwables;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.UpsertExecutor;
import org.apache.phoenix.util.csv.CsvUpsertExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVCommonsLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSVCommonsLoader.class);
    public static final String DEFAULT_ARRAY_ELEMENT_SEPARATOR = ":";
    private static final Map<Character, Character> CTRL_CHARACTER_TABLE = ImmutableMap.builder().put((Object)Character.valueOf('1'), (Object)Character.valueOf('\u0001')).put((Object)Character.valueOf('2'), (Object)Character.valueOf('\u0002')).put((Object)Character.valueOf('3'), (Object)Character.valueOf('\u0003')).put((Object)Character.valueOf('4'), (Object)Character.valueOf('\u0004')).put((Object)Character.valueOf('5'), (Object)Character.valueOf('\u0005')).put((Object)Character.valueOf('6'), (Object)Character.valueOf('\u0006')).put((Object)Character.valueOf('7'), (Object)Character.valueOf('\u0007')).put((Object)Character.valueOf('8'), (Object)Character.valueOf('\b')).put((Object)Character.valueOf('9'), (Object)Character.valueOf('\t')).build();
    private final PhoenixConnection conn;
    private final String tableName;
    private final List<String> columns;
    private final boolean isStrict;
    private final char fieldDelimiter;
    private final char quoteCharacter;
    private final Character escapeCharacter;
    private PhoenixHeaderSource headerSource = PhoenixHeaderSource.FROM_TABLE;
    private final CSVFormat format;
    private final String arrayElementSeparator;

    public CSVCommonsLoader(PhoenixConnection conn, String tableName, List<String> columns, boolean isStrict) {
        this(conn, tableName, columns, isStrict, ',', '\"', null, DEFAULT_ARRAY_ELEMENT_SEPARATOR);
    }

    public CSVCommonsLoader(PhoenixConnection conn, String tableName, List<String> columns, boolean isStrict, char fieldDelimiter, char quoteCharacter, Character escapeCharacter, String arrayElementSeparator) {
        this.conn = conn;
        this.tableName = tableName;
        this.columns = columns;
        this.isStrict = isStrict;
        this.fieldDelimiter = fieldDelimiter;
        this.quoteCharacter = quoteCharacter;
        this.escapeCharacter = escapeCharacter;
        if (columns != null && !columns.isEmpty()) {
            this.headerSource = PhoenixHeaderSource.SUPPLIED_BY_USER;
        } else if (columns != null && columns.isEmpty()) {
            this.headerSource = PhoenixHeaderSource.IN_LINE;
        }
        this.arrayElementSeparator = arrayElementSeparator;
        this.format = this.buildFormat();
    }

    public CSVFormat getFormat() {
        return this.format;
    }

    private CSVFormat buildFormat() {
        CSVFormat format = CSVFormat.DEFAULT.withIgnoreEmptyLines(true).withDelimiter(CSVCommonsLoader.asControlCharacter(this.fieldDelimiter)).withQuote(CSVCommonsLoader.asControlCharacter(this.quoteCharacter));
        if (this.escapeCharacter != null) {
            format = format.withEscape(CSVCommonsLoader.asControlCharacter(this.escapeCharacter.charValue()));
        }
        switch (this.headerSource) {
            case FROM_TABLE: {
                break;
            }
            case IN_LINE: {
                format = format.withHeader(new String[0]);
                break;
            }
            case SUPPLIED_BY_USER: {
                format = format.withHeader(this.columns.toArray(new String[this.columns.size()]));
                break;
            }
            default: {
                throw new RuntimeException("Header source was unable to be inferred.");
            }
        }
        return format;
    }

    public static char asControlCharacter(char delimiter) {
        return CTRL_CHARACTER_TABLE.getOrDefault(Character.valueOf(delimiter), Character.valueOf(delimiter)).charValue();
    }

    public void upsert(String fileName) throws Exception {
        CSVParser parser = CSVParser.parse((File)new File(fileName), (Charset)Charsets.UTF_8, (CSVFormat)this.format);
        this.upsert(parser);
    }

    public void upsert(Reader reader) throws Exception {
        CSVParser parser = new CSVParser(reader, this.format);
        this.upsert(parser);
    }

    private static <T> String buildStringFromList(List<T> list) {
        return Joiner.on((String)", ").useForNull("null").join(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upsert(CSVParser csvParser) throws Exception {
        List<ColumnInfo> columnInfoList = this.buildColumnInfoList(csvParser);
        boolean wasAutoCommit = this.conn.getAutoCommit();
        try {
            this.conn.setAutoCommit(false);
            long start = EnvironmentEdgeManager.currentTimeMillis();
            CsvUpsertListener upsertListener = new CsvUpsertListener(this.conn, this.conn.getMutateBatchSize(), this.isStrict);
            CsvUpsertExecutor csvUpsertExecutor = new CsvUpsertExecutor((Connection)this.conn, SchemaUtil.getEscapedFullTableName(this.tableName), columnInfoList, (UpsertExecutor.UpsertListener<CSVRecord>)upsertListener, this.arrayElementSeparator);
            ((UpsertExecutor)csvUpsertExecutor).execute(csvParser);
            csvUpsertExecutor.close();
            this.conn.commit();
            double elapsedDuration = (double)(EnvironmentEdgeManager.currentTimeMillis() - start) / 1000.0;
            System.out.println("CSV Upsert complete. " + upsertListener.getTotalUpsertCount() + " rows upserted");
            System.out.println("Time: " + elapsedDuration + " sec(s)\n");
        }
        finally {
            if (csvParser != null) {
                csvParser.close();
            }
            if (wasAutoCommit) {
                this.conn.setAutoCommit(true);
            }
        }
    }

    private List<ColumnInfo> buildColumnInfoList(CSVParser parser) throws SQLException {
        List<String> columns = this.columns;
        switch (this.headerSource) {
            case FROM_TABLE: {
                System.out.println(String.format("csv columns from database.", new Object[0]));
                break;
            }
            case IN_LINE: {
                columns = new ArrayList(parser.getHeaderMap().keySet());
                System.out.println(String.format("csv columns from header line. length=%s, %s", columns.size(), CSVCommonsLoader.buildStringFromList(columns)));
                break;
            }
            case SUPPLIED_BY_USER: {
                System.out.println(String.format("csv columns from user. length=%s, %s", columns.size(), CSVCommonsLoader.buildStringFromList(columns)));
                break;
            }
            default: {
                throw new IllegalStateException("parser has unknown column source.");
            }
        }
        return SchemaUtil.generateColumnInfo(this.conn, this.tableName, columns, this.isStrict);
    }

    static class CsvUpsertListener
    implements UpsertExecutor.UpsertListener<CSVRecord> {
        private final PhoenixConnection conn;
        private final int upsertBatchSize;
        private long totalUpserts = 0L;
        private final boolean strict;

        CsvUpsertListener(PhoenixConnection conn, int upsertBatchSize, boolean strict) {
            this.conn = conn;
            this.upsertBatchSize = upsertBatchSize;
            this.strict = strict;
        }

        @Override
        public void upsertDone(long upsertCount) {
            this.totalUpserts = upsertCount;
            if (upsertCount % (long)this.upsertBatchSize == 0L) {
                if (upsertCount % 1000L == 0L) {
                    LOGGER.info("Processed upsert #{}", (Object)upsertCount);
                }
                try {
                    LOGGER.info("Committing after {} records", (Object)upsertCount);
                    this.conn.commit();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public void errorOnRecord(CSVRecord csvRecord, Throwable throwable) {
            LOGGER.error("Error upserting record " + csvRecord, (Object)throwable.getMessage());
            if (this.strict) {
                Throwables.propagate((Throwable)throwable);
            }
        }

        public long getTotalUpsertCount() {
            return this.totalUpserts;
        }
    }

    public static enum PhoenixHeaderSource {
        FROM_TABLE,
        IN_LINE,
        SUPPLIED_BY_USER;

    }
}

