/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import java.math.BigDecimal;
import java.util.Random;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PRealNumber;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PUnsignedDouble;
import org.apache.phoenix.schema.types.PUnsignedFloat;
import org.apache.phoenix.schema.types.PUnsignedInt;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.schema.types.PUnsignedSmallint;
import org.apache.phoenix.schema.types.PUnsignedTinyint;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PhoenixArray;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.primitives.Doubles;

public class PDouble
extends PRealNumber<Double> {
    public static final PDouble INSTANCE = new PDouble();

    private PDouble() {
        super("DOUBLE", 8, Double.class, new DoubleCodec(), 7);
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        if (lhs == rhs) {
            return 0;
        }
        if (lhs == null) {
            return -1;
        }
        if (rhs == null) {
            return 1;
        }
        if (rhsType == PDecimal.INSTANCE) {
            return -((BigDecimal)rhs).compareTo(BigDecimal.valueOf(((Number)lhs).doubleValue()));
        }
        return Doubles.compare((double)((Number)lhs).doubleValue(), (double)((Number)rhs).doubleValue());
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public Integer getByteSize() {
        return 8;
    }

    @Override
    public Integer getScale(Object o) {
        if (o == null) {
            return null;
        }
        Double v = (Double)o;
        BigDecimal bd = BigDecimal.valueOf(v);
        return bd.scale() == 0 ? null : Integer.valueOf(bd.scale());
    }

    @Override
    public Integer getMaxLength(Object o) {
        if (o == null) {
            return null;
        }
        Double v = (Double)o;
        BigDecimal db = BigDecimal.valueOf(v);
        return db.precision();
    }

    @Override
    public byte[] toBytes(Object object) {
        byte[] b = new byte[8];
        this.toBytes(object, b, 0);
        return b;
    }

    @Override
    public int toBytes(Object object, byte[] bytes, int offset) {
        if (object == null) {
            throw PDouble.newIllegalDataException(this + " may not be null");
        }
        return this.getCodec().encodeDouble(((Number)object).doubleValue(), bytes, offset);
    }

    @Override
    public Object toObject(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw PDouble.newIllegalDataException(e);
        }
    }

    @Override
    public Object toObject(Object object, PDataType actualType) {
        if (object == null) {
            return null;
        }
        if (PDouble.equalsAny(actualType, INSTANCE, PUnsignedDouble.INSTANCE)) {
            return object;
        }
        if (PDouble.equalsAny(actualType, PFloat.INSTANCE, PUnsignedFloat.INSTANCE)) {
            double de = ((Float)object).floatValue();
            return de;
        }
        if (PDouble.equalsAny(actualType, PLong.INSTANCE, PUnsignedLong.INSTANCE)) {
            double de = ((Long)object).longValue();
            return de;
        }
        if (PDouble.equalsAny(actualType, PInteger.INSTANCE, PUnsignedInt.INSTANCE)) {
            double de = ((Integer)object).intValue();
            return de;
        }
        if (PDouble.equalsAny(actualType, PTinyint.INSTANCE, PUnsignedTinyint.INSTANCE)) {
            double de = ((Byte)object).byteValue();
            return de;
        }
        if (PDouble.equalsAny(actualType, PSmallint.INSTANCE, PUnsignedSmallint.INSTANCE)) {
            double de = ((Short)object).shortValue();
            return de;
        }
        if (actualType == PDecimal.INSTANCE) {
            BigDecimal d = (BigDecimal)object;
            return d.doubleValue();
        }
        return PDouble.throwConstraintViolationException(actualType, this);
    }

    @Override
    public Double toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        if (l <= 0) {
            return null;
        }
        if (PDouble.equalsAny(actualType, INSTANCE, PUnsignedDouble.INSTANCE, PFloat.INSTANCE, PUnsignedFloat.INSTANCE, PLong.INSTANCE, PUnsignedLong.INSTANCE, PInteger.INSTANCE, PUnsignedInt.INSTANCE, PSmallint.INSTANCE, PUnsignedSmallint.INSTANCE, PTinyint.INSTANCE, PUnsignedTinyint.INSTANCE)) {
            return actualType.getCodec().decodeDouble(b, o, sortOrder);
        }
        if (actualType == PDecimal.INSTANCE) {
            BigDecimal bd = (BigDecimal)actualType.toObject(b, o, l, actualType, sortOrder);
            return bd.doubleValue();
        }
        PDouble.throwConstraintViolationException(actualType, this);
        return null;
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        if (value != null) {
            double d = (Double)value;
            if (targetType.equals(PUnsignedDouble.INSTANCE)) {
                return d >= 0.0;
            }
            if (targetType.equals(PFloat.INSTANCE)) {
                return Double.isNaN(d) || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY || d >= -3.4028234663852886E38 && d <= 3.4028234663852886E38;
            }
            if (targetType.equals(PUnsignedFloat.INSTANCE)) {
                return Double.isNaN(d) || d == Double.POSITIVE_INFINITY || d >= 0.0 && d <= 3.4028234663852886E38;
            }
            if (targetType.equals(PUnsignedLong.INSTANCE)) {
                return d >= 0.0 && d <= 9.223372036854776E18;
            }
            if (targetType.equals(PLong.INSTANCE)) {
                return d >= -9.223372036854776E18 && d <= 9.223372036854776E18;
            }
            if (targetType.equals(PUnsignedInt.INSTANCE)) {
                return d >= 0.0 && d <= 2.147483647E9;
            }
            if (targetType.equals(PInteger.INSTANCE)) {
                return d >= -2.147483648E9 && d <= 2.147483647E9;
            }
            if (targetType.equals(PUnsignedSmallint.INSTANCE)) {
                return d >= 0.0 && d <= 32767.0;
            }
            if (targetType.equals(PSmallint.INSTANCE)) {
                return d >= -32768.0 && d <= 32767.0;
            }
            if (targetType.equals(PTinyint.INSTANCE)) {
                return d >= -128.0 && d <= 127.0;
            }
            if (targetType.equals(PUnsignedTinyint.INSTANCE)) {
                return d >= 0.0 && d <= 127.0;
            }
        }
        return super.isCoercibleTo(targetType, value);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return PDouble.equalsAny(targetType, this, PDecimal.INSTANCE, PVarbinary.INSTANCE, PBinary.INSTANCE);
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return ((Random)RANDOM.get()).nextDouble();
    }

    static class DoubleCodec
    extends PDataType.BaseCodec {
        DoubleCodec() {
        }

        @Override
        public long decodeLong(byte[] b, int o, SortOrder sortOrder) {
            double v = this.decodeDouble(b, o, sortOrder);
            if (v < -9.223372036854776E18 || v > 9.223372036854776E18) {
                throw PDataType.newIllegalDataException("Value " + v + " cannot be cast to Long without changing its value");
            }
            return (long)v;
        }

        @Override
        public int decodeInt(byte[] b, int o, SortOrder sortOrder) {
            double v = this.decodeDouble(b, o, sortOrder);
            if (v < -2.147483648E9 || v > 2.147483647E9) {
                throw PDataType.newIllegalDataException("Value " + v + " cannot be cast to Integer without changing its value");
            }
            return (int)v;
        }

        @Override
        public byte decodeByte(byte[] b, int o, SortOrder sortOrder) {
            double v = this.decodeDouble(b, o, sortOrder);
            if (v < -128.0 || v > 127.0) {
                throw PDataType.newIllegalDataException("Value " + v + " cannot be cast to Byte without changing its value");
            }
            return (byte)v;
        }

        @Override
        public short decodeShort(byte[] b, int o, SortOrder sortOrder) {
            double v = this.decodeDouble(b, o, sortOrder);
            if (v < -32768.0 || v > 32767.0) {
                throw PDataType.newIllegalDataException("Value " + v + " cannot be cast to Short without changing its value");
            }
            return (short)v;
        }

        @Override
        public double decodeDouble(byte[] bytes, int o, SortOrder sortOrder) {
            long l;
            Preconditions.checkNotNull((Object)((Object)sortOrder));
            PDataType.checkForSufficientLength(bytes, o, 8);
            if (sortOrder == SortOrder.DESC) {
                l = 0L;
                for (int i = o; i < o + 8; ++i) {
                    l <<= 8;
                    l ^= (long)((bytes[i] ^ 0xFF) & 0xFF);
                }
            } else {
                l = Bytes.toLong((byte[])bytes, (int)o);
            }
            --l;
            l ^= (l ^ 0xFFFFFFFFFFFFFFFFL) >> 63 | Long.MIN_VALUE;
            return Double.longBitsToDouble(l);
        }

        @Override
        public float decodeFloat(byte[] b, int o, SortOrder sortOrder) {
            double v = this.decodeDouble(b, o, sortOrder);
            if (Double.isNaN(v) || v == Double.NEGATIVE_INFINITY || v == Double.POSITIVE_INFINITY || v >= -3.4028234663852886E38 && v <= 3.4028234663852886E38) {
                return (float)v;
            }
            throw PDataType.newIllegalDataException("Value " + v + " cannot be cast to Float without changing its value");
        }

        @Override
        public int encodeShort(short v, byte[] b, int o) {
            return this.encodeDouble(v, b, o);
        }

        @Override
        public int encodeLong(long v, byte[] b, int o) {
            return this.encodeDouble(v, b, o);
        }

        @Override
        public int encodeInt(int v, byte[] b, int o) {
            return this.encodeDouble(v, b, o);
        }

        @Override
        public int encodeByte(byte v, byte[] b, int o) {
            return this.encodeDouble(v, b, o);
        }

        @Override
        public int encodeDouble(double v, byte[] b, int o) {
            PDataType.checkForSufficientLength(b, o, 8);
            long l = Double.doubleToLongBits(v);
            l = (l ^ (l >> 63 | Long.MIN_VALUE)) + 1L;
            Bytes.putLong((byte[])b, (int)o, (long)l);
            return 8;
        }

        @Override
        public int encodeFloat(float v, byte[] b, int o) {
            return this.encodeDouble(v, b, o);
        }

        @Override
        public PDataType.PhoenixArrayFactory getPhoenixArrayFactory() {
            return new PDataType.PhoenixArrayFactory(){

                @Override
                public PhoenixArray newArray(PDataType type, Object[] elements) {
                    return new PhoenixArray.PrimitiveDoublePhoenixArray(type, elements);
                }
            };
        }
    }
}

