/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import java.math.BigDecimal;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PhoenixArray;

public class PDecimalArray
extends PArrayDataType<BigDecimal[]> {
    public static final PDecimalArray INSTANCE = new PDecimalArray();

    private PDecimalArray() {
        super("DECIMAL ARRAY", 3000 + PDecimal.INSTANCE.getSqlType(), PhoenixArray.class, null, 35);
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public boolean isFixedWidth() {
        return false;
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        return this.compareTo(lhs, rhs);
    }

    @Override
    public Integer getByteSize() {
        return null;
    }

    @Override
    public byte[] toBytes(Object object) {
        return this.toBytes(object, SortOrder.ASC);
    }

    @Override
    public byte[] toBytes(Object object, SortOrder sortOrder) {
        return this.toBytes(object, PDecimal.INSTANCE, sortOrder);
    }

    @Override
    public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        return this.toObject(bytes, offset, length, PDecimal.INSTANCE, sortOrder, maxLength, scale, PDecimal.INSTANCE);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return this.isCoercibleTo(targetType, this);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        Object[] decimalArr;
        if (value == null) {
            return true;
        }
        PhoenixArray pArr = (PhoenixArray)value;
        for (Object i : decimalArr = (Object[])pArr.array) {
            if (super.isCoercibleTo((PDataType)PDecimal.INSTANCE, i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return this.getSampleValue(PDecimal.INSTANCE, arrayLength, maxLength);
    }
}

