/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;

public enum ColumnModifier {
    SORT_DESC(1){

        @Override
        public byte[] apply(byte[] src, int srcOffset, byte[] dest, int dstOffset, int length) {
            Preconditions.checkNotNull((Object)src);
            Preconditions.checkNotNull((Object)dest);
            for (int i = 0; i < length; ++i) {
                dest[dstOffset + i] = (byte)(src[srcOffset + i] ^ 0xFF);
            }
            return dest;
        }

        @Override
        public byte apply(byte b) {
            return (byte)(b ^ 0xFF);
        }

        @Override
        public CompareFilter.CompareOp transform(CompareFilter.CompareOp op) {
            switch (op) {
                case EQUAL: {
                    return op;
                }
                case GREATER: {
                    return CompareFilter.CompareOp.LESS;
                }
                case GREATER_OR_EQUAL: {
                    return CompareFilter.CompareOp.LESS_OR_EQUAL;
                }
                case LESS: {
                    return CompareFilter.CompareOp.GREATER;
                }
                case LESS_OR_EQUAL: {
                    return CompareFilter.CompareOp.GREATER_OR_EQUAL;
                }
            }
            throw new IllegalArgumentException("Unknown operator " + op);
        }

        @Override
        public byte[] apply(byte[] src, int srcOffset, int length) {
            return this.apply(src, srcOffset, new byte[length], 0, length);
        }
    };

    private final int serializationId;

    private ColumnModifier(int serializationId) {
        this.serializationId = serializationId;
    }

    public int getSerializationId() {
        return this.serializationId;
    }

    public static ColumnModifier fromDDLValue(String modifier) {
        if (modifier == null) {
            return null;
        }
        if (modifier.equalsIgnoreCase("ASC")) {
            return null;
        }
        if (modifier.equalsIgnoreCase("DESC")) {
            return SORT_DESC;
        }
        return null;
    }

    public static ColumnModifier fromSystemValue(int value) {
        for (ColumnModifier mod : ColumnModifier.values()) {
            if (mod.getSerializationId() != value) continue;
            return mod;
        }
        return null;
    }

    public static int toSystemValue(ColumnModifier columnModifier) {
        if (columnModifier == null) {
            return 0;
        }
        return columnModifier.getSerializationId();
    }

    public abstract byte[] apply(byte[] var1, int var2, byte[] var3, int var4, int var5);

    public abstract byte[] apply(byte[] var1, int var2, int var3);

    public abstract byte apply(byte var1);

    public abstract CompareFilter.CompareOp transform(CompareFilter.CompareOp var1);
}

