/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.parse.CompoundParseNode;
import org.apache.phoenix.parse.ParseException;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeVisitor;

public class InListParseNode
extends CompoundParseNode {
    private final boolean negate;

    InListParseNode(List<ParseNode> children, boolean negate) {
        super(children);
        for (int i = 1; i < children.size(); ++i) {
            ParseNode child = children.get(i);
            if (child.isStateless()) continue;
            throw new ParseException(new SQLExceptionInfo.Builder(SQLExceptionCode.VALUE_IN_LIST_NOT_CONSTANT).build().buildException());
        }
        this.negate = negate;
    }

    public boolean isNegate() {
        return this.negate;
    }

    @Override
    public <T> T accept(ParseNodeVisitor<T> visitor) throws SQLException {
        List l = Collections.emptyList();
        if (visitor.visitEnter(this)) {
            l = this.acceptChildren(visitor);
        }
        return visitor.visitLeave(this, l);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.negate ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InListParseNode other = (InListParseNode)obj;
        return this.negate == other.negate;
    }

    @Override
    public void toSQL(ColumnResolver resolver, StringBuilder buf) {
        List<ParseNode> children = this.getChildren();
        children.get(0).toSQL(resolver, buf);
        buf.append(' ');
        if (this.negate) {
            buf.append("NOT ");
        }
        buf.append("IN");
        buf.append('(');
        if (children.size() > 1) {
            for (int i = 1; i < children.size(); ++i) {
                children.get(i).toSQL(resolver, buf);
                buf.append(',');
            }
            buf.setLength(buf.length() - 1);
        }
        buf.append(')');
    }
}

