/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.util;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.mapreduce.util.PhoenixMultiInputUtil;
import org.apache.phoenix.mapreduce.util.PhoenixMultiViewListProvider;
import org.apache.phoenix.mapreduce.util.ViewInfoTracker;
import org.apache.phoenix.mapreduce.util.ViewInfoWritable;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPhoenixMultiViewListProvider
implements PhoenixMultiViewListProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPhoenixMultiViewListProvider.class);

    @Override
    public List<ViewInfoWritable> getPhoenixMultiViewList(Configuration configuration) {
        boolean isFetchAll;
        boolean bl = isFetchAll = configuration.get("phoenix.mapreduce.phoenix_ttl.all") != null;
        if (!isFetchAll) {
            return this.getTenantOrViewMultiViewList(configuration);
        }
        ArrayList<ViewInfoWritable> viewInfoWritables = new ArrayList<ViewInfoWritable>();
        boolean isQueryMore = true;
        String query = PhoenixMultiInputUtil.getFetchViewQuery(configuration);
        int limit = PhoenixConfigurationUtil.getMultiViewQueryMoreSplitSize(configuration);
        String schema = null;
        String tableName = configuration.get("phoenix.mapreduce.phoenix_ttl.per_view");
        if (tableName != null) {
            schema = SchemaUtil.getSchemaNameFromFullName(tableName);
        }
        String tenantId = configuration.get("phoenix.mapreduce.tenantid");
        try (PhoenixConnection connection = (PhoenixConnection)ConnectionUtil.getInputConnection(configuration);
             PreparedStatement stmt = connection.prepareStatement(query);){
            do {
                stmt.setString(1, tenantId);
                stmt.setString(2, schema);
                stmt.setString(3, tableName);
                stmt.setInt(4, limit);
                ResultSet viewRs = stmt.executeQuery();
                String fullTableName = null;
                while (viewRs.next()) {
                    tenantId = viewRs.getString(1);
                    schema = viewRs.getString(2);
                    fullTableName = tableName = viewRs.getString(3);
                    Long viewTtlValue = viewRs.getLong(4);
                    if (schema != null && schema.length() > 0) {
                        fullTableName = SchemaUtil.getTableName(schema, tableName);
                    }
                    if (this.isParentHasTTL(connection, tenantId, fullTableName)) continue;
                    this.addingViewIndexToTheFinalList(connection, tenantId, fullTableName, viewTtlValue, viewInfoWritables);
                }
                if (!isQueryMore || fullTableName != null) continue;
                isQueryMore = false;
            } while (isQueryMore);
        }
        catch (Exception e) {
            LOGGER.error("Getting view info failed with: " + e.getMessage());
        }
        return viewInfoWritables;
    }

    public List<ViewInfoWritable> getTenantOrViewMultiViewList(Configuration configuration) {
        ArrayList<ViewInfoWritable> viewInfoWritables = new ArrayList<ViewInfoWritable>();
        String query = PhoenixMultiInputUtil.getFetchViewQuery(configuration);
        try (PhoenixConnection connection = (PhoenixConnection)ConnectionUtil.getInputConnection(configuration);
             Statement stmt = connection.createStatement();){
            ResultSet viewRs = stmt.executeQuery(query);
            while (viewRs.next()) {
                String tenantId = viewRs.getString(1);
                String schema = viewRs.getString(2);
                String tableName = viewRs.getString(3);
                Long viewTtlValue = viewRs.getLong(4);
                String fullTableName = tableName;
                if (schema != null && schema.length() > 0) {
                    fullTableName = SchemaUtil.getTableName(schema, tableName);
                }
                if (this.isParentHasTTL(connection, tenantId, fullTableName)) continue;
                this.addingViewIndexToTheFinalList(connection, tenantId, fullTableName, viewTtlValue, viewInfoWritables);
            }
        }
        catch (Exception e) {
            LOGGER.error("Getting view info failed with: " + e.getMessage());
        }
        return viewInfoWritables;
    }

    private boolean isParentHasTTL(PhoenixConnection connection, String tenantId, String fullTableName) {
        boolean skip = false;
        try {
            PTable pTable = PhoenixRuntime.getTable(connection, tenantId, fullTableName);
            PTable parentTable = PhoenixRuntime.getTable(connection, null, pTable.getParentName().toString());
            if (parentTable.getType() == PTableType.VIEW && parentTable.getPhoenixTTL() > 0L) {
                skip = true;
            }
        }
        catch (Exception e) {
            skip = true;
            LOGGER.error(String.format("Had an issue to process the view: %s, tenantId: see error %s ", fullTableName, tenantId, e.getMessage()));
        }
        return skip;
    }

    private void addingViewIndexToTheFinalList(PhoenixConnection connection, String tenantId, String fullTableName, long viewTtlValue, List<ViewInfoWritable> viewInfoWritables) throws Exception {
        PTable pTable = PhoenixRuntime.getTable(connection, tenantId, fullTableName);
        ViewInfoTracker viewInfoTracker = new ViewInfoTracker(tenantId, fullTableName, viewTtlValue, pTable.getPhysicalName().getString(), false);
        viewInfoWritables.add(viewInfoTracker);
        List<PTable> allIndexesOnView = pTable.getIndexes();
        for (PTable viewIndexTable : allIndexesOnView) {
            String indexName = viewIndexTable.getTableName().getString();
            String indexSchema = viewIndexTable.getSchemaName().getString();
            if (indexName.contains("#")) {
                indexName = SchemaUtil.getTableNameFromFullName(indexName, "#");
            }
            indexName = SchemaUtil.getTableNameFromFullName(indexName);
            indexName = SchemaUtil.getTableName(indexSchema, indexName);
            ViewInfoTracker viewInfoTrackerForIndexEntry = new ViewInfoTracker(tenantId, fullTableName, viewTtlValue, indexName, true);
            viewInfoWritables.add(viewInfoTrackerForIndexEntry);
        }
    }
}

