/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.bulkload;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.phoenix.mapreduce.bulkload.TargetTableRef;
import org.apache.phoenix.thirdparty.com.google.common.base.Function;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.JacksonUtil;

public class TargetTableRefFunctions {
    public static Function<TargetTableRef, String> TO_JSON = new Function<TargetTableRef, String>(){

        public String apply(TargetTableRef input) {
            try {
                return JacksonUtil.getObjectWriter().writeValueAsString((Object)input);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    };
    public static Function<String, TargetTableRef> FROM_JSON = new Function<String, TargetTableRef>(){

        public TargetTableRef apply(String json) {
            try {
                return (TargetTableRef)JacksonUtil.getObjectReader(TargetTableRef.class).readValue(json);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    };
    public static Function<List<TargetTableRef>, String> NAMES_TO_JSON = new Function<List<TargetTableRef>, String>(){

        public String apply(List<TargetTableRef> input) {
            try {
                ArrayList tableNames = Lists.newArrayListWithCapacity((int)input.size());
                for (TargetTableRef table : input) {
                    tableNames.add(table.getPhysicalName());
                }
                return JacksonUtil.getObjectWriter().writeValueAsString((Object)tableNames);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    };
    public static Function<List<TargetTableRef>, String> LOGICAL_NAMES_TO_JSON = new Function<List<TargetTableRef>, String>(){

        public String apply(List<TargetTableRef> input) {
            try {
                ArrayList tableNames = Lists.newArrayListWithCapacity((int)input.size());
                for (TargetTableRef table : input) {
                    tableNames.add(table.getLogicalName());
                }
                return JacksonUtil.getObjectWriter().writeValueAsString((Object)tableNames);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    };
    public static Function<String, List<String>> NAMES_FROM_JSON = new Function<String, List<String>>(){

        public List<String> apply(String json) {
            try {
                return (List)JacksonUtil.getObjectReader(ArrayList.class).readValue(json);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    };
}

