/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;

public class PhoenixInputSplit
extends InputSplit
implements Writable {
    private List<Scan> scans;
    private KeyRange keyRange;
    private String regionLocation = null;
    private long regionSize = 0L;

    public PhoenixInputSplit() {
    }

    public PhoenixInputSplit(List<Scan> scans) {
        this(scans, 0L, null);
    }

    public PhoenixInputSplit(List<Scan> scans, long regionSize, String regionLocation) {
        Preconditions.checkNotNull(scans);
        Preconditions.checkState((!scans.isEmpty() ? 1 : 0) != 0);
        this.scans = scans;
        this.regionSize = regionSize;
        this.regionLocation = regionLocation;
        this.init();
    }

    public List<Scan> getScans() {
        return this.scans;
    }

    public KeyRange getKeyRange() {
        return this.keyRange;
    }

    private void init() {
        this.keyRange = KeyRange.getKeyRange(this.scans.get(0).getStartRow(), this.scans.get(this.scans.size() - 1).getStopRow());
    }

    public void readFields(DataInput input) throws IOException {
        this.regionLocation = WritableUtils.readString((DataInput)input);
        this.regionSize = WritableUtils.readVLong((DataInput)input);
        int count = WritableUtils.readVInt((DataInput)input);
        this.scans = Lists.newArrayListWithExpectedSize((int)count);
        for (int i = 0; i < count; ++i) {
            byte[] protoScanBytes = new byte[WritableUtils.readVInt((DataInput)input)];
            input.readFully(protoScanBytes);
            ClientProtos.Scan protoScan = ClientProtos.Scan.parseFrom((byte[])protoScanBytes);
            Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)protoScan);
            this.scans.add(scan);
        }
        this.init();
    }

    public void write(DataOutput output) throws IOException {
        WritableUtils.writeString((DataOutput)output, (String)this.regionLocation);
        WritableUtils.writeVLong((DataOutput)output, (long)this.regionSize);
        Preconditions.checkNotNull(this.scans);
        WritableUtils.writeVInt((DataOutput)output, (int)this.scans.size());
        for (Scan scan : this.scans) {
            ClientProtos.Scan protoScan = ProtobufUtil.toScan((Scan)scan);
            byte[] protoScanBytes = protoScan.toByteArray();
            WritableUtils.writeVInt((DataOutput)output, (int)protoScanBytes.length);
            output.write(protoScanBytes);
        }
    }

    public long getLength() throws IOException, InterruptedException {
        return this.regionSize;
    }

    public String[] getLocations() throws IOException, InterruptedException {
        if (this.regionLocation == null) {
            return new String[0];
        }
        return new String[]{this.regionLocation};
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.keyRange.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhoenixInputSplit)) {
            return false;
        }
        PhoenixInputSplit other = (PhoenixInputSplit)((Object)obj);
        return !(this.keyRange == null ? other.keyRange != null : !this.keyRange.equals(other.keyRange));
    }
}

