/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.phoenix.hbase.index.IndexRegionObserver;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.ImportPreUpsertKeyValueProcessor;
import org.apache.phoenix.mapreduce.bulkload.TableRowkeyPair;
import org.apache.phoenix.mapreduce.bulkload.TargetTableRefFunctions;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.base.Function;
import org.apache.phoenix.thirdparty.com.google.common.base.Joiner;
import org.apache.phoenix.thirdparty.com.google.common.base.Splitter;
import org.apache.phoenix.thirdparty.com.google.common.base.Throwables;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.thirdparty.com.google.common.collect.Iterables;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.UpsertExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FormatToBytesWritableMapper<RECORD>
extends Mapper<LongWritable, Text, TableRowkeyPair, ImmutableBytesWritable> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(FormatToBytesWritableMapper.class);
    protected static final String COUNTER_GROUP_NAME = "Phoenix MapReduce Import";
    public static final String TABLE_NAME_CONFKEY = "phoenix.mapreduce.import.tablename";
    public static final String COLUMN_INFO_CONFKEY = "phoenix.mapreduce.import.columninfos";
    public static final String IGNORE_INVALID_ROW_CONFKEY = "phoenix.mapreduce.import.ignoreinvalidrow";
    public static final String TABLE_NAMES_CONFKEY = "phoenix.mapreduce.import.tablenames";
    public static final String LOGICAL_NAMES_CONFKEY = "phoenix.mapreduce.import.logicalnames";
    protected PhoenixConnection conn;
    protected UpsertExecutor<RECORD, ?> upsertExecutor;
    protected ImportPreUpsertKeyValueProcessor preUpdateProcessor;
    protected IndexStatusUpdater[] indexStatusUpdaters;
    protected List<String> tableNames;
    protected List<String> logicalNames;
    protected MapperUpsertListener<RECORD> upsertListener;
    protected Map<byte[], Integer> columnIndexes;

    protected abstract UpsertExecutor<RECORD, ?> buildUpsertExecutor(Configuration var1);

    protected abstract LineParser<RECORD> getLineParser();

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        Properties clientInfos = new Properties();
        for (Map.Entry entry : conf) {
            clientInfos.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        try {
            this.conn = (PhoenixConnection)QueryUtil.getConnectionOnServer(clientInfos, conf);
            this.conn.setAutoCommit(false);
            String tableNamesConf = conf.get(TABLE_NAMES_CONFKEY);
            String logicalNamesConf = conf.get(LOGICAL_NAMES_CONFKEY);
            this.tableNames = (List)TargetTableRefFunctions.NAMES_FROM_JSON.apply((Object)tableNamesConf);
            this.logicalNames = (List)TargetTableRefFunctions.NAMES_FROM_JSON.apply((Object)logicalNamesConf);
            this.initColumnIndexes();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        this.upsertListener = new MapperUpsertListener(context, conf.getBoolean(IGNORE_INVALID_ROW_CONFKEY, true));
        this.upsertExecutor = this.buildUpsertExecutor(conf);
        this.preUpdateProcessor = PhoenixConfigurationUtil.loadPreUpsertProcessor(conf);
    }

    protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        if (this.conn == null) {
            throw new RuntimeException("Connection not initialized.");
        }
        try {
            Object record = null;
            try {
                record = this.getLineParser().parse(value.toString());
            }
            catch (IOException e) {
                context.getCounter(COUNTER_GROUP_NAME, "Parser errors").increment(1L);
                return;
            }
            if (record == null) {
                context.getCounter(COUNTER_GROUP_NAME, "Empty records").increment(1L);
                return;
            }
            this.upsertExecutor.execute(ImmutableList.of(record));
            HashMap map = new HashMap();
            Iterator<Pair<byte[], List<Cell>>> uncommittedDataIterator = PhoenixRuntime.getUncommittedDataIterator(this.conn, true);
            block4: while (uncommittedDataIterator.hasNext()) {
                Pair<byte[], List<Cell>> kvPair = uncommittedDataIterator.next();
                List<Cell> keyValueList = (List<Cell>)kvPair.getSecond();
                byte[] tableName = (byte[])kvPair.getFirst();
                keyValueList = this.preUpdateProcessor.preUpsert(tableName, keyValueList);
                for (int i = 0; i < this.tableNames.size(); ++i) {
                    if (Bytes.compareTo((byte[])Bytes.toBytes((String)this.tableNames.get(i)), (byte[])tableName) != 0) continue;
                    if (!map.containsKey(i)) {
                        map.put(i, new ArrayList());
                    }
                    List cellsForTable = (List)map.get(i);
                    if (this.indexStatusUpdaters[i] != null) {
                        this.indexStatusUpdaters[i].setVerified(keyValueList);
                    }
                    cellsForTable.addAll(keyValueList);
                    continue block4;
                }
            }
            for (Map.Entry rowEntry : map.entrySet()) {
                int tableIndex = (Integer)rowEntry.getKey();
                List lkv = (List)rowEntry.getValue();
                this.writeAggregatedRow(context, this.tableNames.get(tableIndex), lkv);
            }
            this.conn.rollback();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void initColumnIndexes() throws SQLException {
        this.columnIndexes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        this.indexStatusUpdaters = new IndexStatusUpdater[this.logicalNames.size()];
        int columnIndex = 0;
        for (int index = 0; index < this.logicalNames.size(); ++index) {
            int i;
            PTable table = PhoenixRuntime.getTable(this.conn, this.logicalNames.get(index));
            if (!table.getImmutableStorageScheme().equals(PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN)) {
                List<PColumnFamily> cfs = table.getColumnFamilies();
                for (i = 0; i < cfs.size(); ++i) {
                    byte[] family = cfs.get(i).getName().getBytes();
                    byte[] cfn = Bytes.add((byte[])family, (byte[])QueryConstants.NAMESPACE_SEPARATOR_BYTES, (byte[])QueryConstants.SINGLE_KEYVALUE_COLUMN_QUALIFIER_BYTES);
                    this.columnIndexes.put(cfn, new Integer(columnIndex));
                    ++columnIndex;
                }
            } else {
                List<PColumn> cls = table.getColumns();
                for (i = 0; i < cls.size(); ++i) {
                    byte[] cq;
                    PColumn c = cls.get(i);
                    byte[] family = new byte[]{};
                    if (!SchemaUtil.isPKColumn(c)) {
                        family = c.getFamilyName().getBytes();
                        cq = c.getColumnQualifierBytes();
                    } else {
                        cq = c.getName().getBytes();
                    }
                    byte[] cfn = Bytes.add((byte[])family, (byte[])QueryConstants.NAMESPACE_SEPARATOR_BYTES, (byte[])cq);
                    if (this.columnIndexes.containsKey(cfn)) continue;
                    this.columnIndexes.put(cfn, new Integer(columnIndex));
                    ++columnIndex;
                }
            }
            byte[] emptyColumnFamily = SchemaUtil.getEmptyColumnFamily(table);
            byte[] emptyKeyValue = (byte[])EncodedColumnsUtil.getEmptyKeyValueInfo(table).getFirst();
            byte[] cfn = Bytes.add((byte[])emptyColumnFamily, (byte[])QueryConstants.NAMESPACE_SEPARATOR_BYTES, (byte[])emptyKeyValue);
            this.columnIndexes.put(cfn, new Integer(columnIndex));
            ++columnIndex;
            if (PTable.IndexType.GLOBAL != table.getIndexType()) continue;
            this.indexStatusUpdaters[index] = new IndexStatusUpdater(emptyColumnFamily, emptyKeyValue);
        }
    }

    private int findIndex(Cell cell) throws IOException {
        byte[] cq;
        byte[] familyName = Bytes.copy((byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength());
        byte[] cfn = Bytes.add((byte[])familyName, (byte[])QueryConstants.NAMESPACE_SEPARATOR_BYTES, (byte[])(cq = Bytes.copy((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength())));
        if (this.columnIndexes.containsKey(cfn)) {
            return this.columnIndexes.get(cfn);
        }
        return -1;
    }

    private void writeAggregatedRow(Mapper.Context context, String tableName, List<Cell> lkv) throws IOException, InterruptedException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        DataOutputStream outputStream = new DataOutputStream(bos);
        ImmutableBytesWritable outputKey = null;
        if (!lkv.isEmpty()) {
            for (Cell cell : lkv) {
                int i;
                if (outputKey == null || Bytes.compareTo((byte[])outputKey.get(), (int)outputKey.getOffset(), (int)outputKey.getLength(), (byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength()) != 0) {
                    if (outputKey != null) {
                        ImmutableBytesWritable aggregatedArray = new ImmutableBytesWritable(bos.toByteArray());
                        outputStream.close();
                        context.write((Object)new TableRowkeyPair(tableName, outputKey), (Object)aggregatedArray);
                    }
                    outputKey = new ImmutableBytesWritable(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength());
                    bos = new ByteArrayOutputStream(1024);
                    outputStream = new DataOutputStream(bos);
                }
                if ((i = this.findIndex(cell)) == -1) continue;
                outputStream.writeByte(cell.getTypeByte());
                WritableUtils.writeVLong((DataOutput)outputStream, (long)cell.getTimestamp());
                WritableUtils.writeVInt((DataOutput)outputStream, (int)i);
                WritableUtils.writeVInt((DataOutput)outputStream, (int)cell.getValueLength());
                outputStream.write(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
            }
            ImmutableBytesWritable aggregatedArray = new ImmutableBytesWritable(bos.toByteArray());
            outputStream.close();
            context.write((Object)new TableRowkeyPair(tableName, outputKey), (Object)aggregatedArray);
        }
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    static void configureColumnInfoList(Configuration conf, List<ColumnInfo> columnInfoList) {
        conf.set(COLUMN_INFO_CONFKEY, Joiner.on((String)"|").useForNull("").join(columnInfoList));
    }

    @VisibleForTesting
    static List<ColumnInfo> buildColumnInfoList(Configuration conf) {
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)Splitter.on((String)"|").split((CharSequence)conf.get(COLUMN_INFO_CONFKEY)), (Function)new Function<String, ColumnInfo>(){

            @Nullable
            public ColumnInfo apply(@Nullable String input) {
                if (input == null || input.isEmpty()) {
                    return null;
                }
                return ColumnInfo.fromString(input);
            }
        }));
    }

    private static class IndexStatusUpdater {
        private final byte[] emptyKeyValueCF;
        private final int emptyKeyValueCFLength;
        private final byte[] emptyKeyValueQualifier;
        private final int emptyKeyValueQualifierLength;

        public IndexStatusUpdater(byte[] emptyKeyValueCF, byte[] emptyKeyValueQualifier) {
            this.emptyKeyValueCF = emptyKeyValueCF;
            this.emptyKeyValueQualifier = emptyKeyValueQualifier;
            this.emptyKeyValueCFLength = emptyKeyValueCF.length;
            this.emptyKeyValueQualifierLength = emptyKeyValueQualifier.length;
        }

        public void setVerified(List<Cell> keyValues) {
            for (int i = 0; i < keyValues.size(); ++i) {
                Cell kv = keyValues.get(i);
                if (CellUtil.compareFamilies((Cell)kv, (byte[])this.emptyKeyValueCF, (int)0, (int)this.emptyKeyValueCFLength) != 0 || CellUtil.compareQualifiers((Cell)kv, (byte[])this.emptyKeyValueQualifier, (int)0, (int)this.emptyKeyValueQualifierLength) != 0) continue;
                if (kv.getValueLength() != 1) {
                    throw new IllegalArgumentException("Empty cell value length is not 1");
                }
                kv.getValueArray()[kv.getValueOffset()] = IndexRegionObserver.VERIFIED_BYTES[0];
            }
        }
    }

    public static class DefaultImportPreUpsertKeyValueProcessor
    implements ImportPreUpsertKeyValueProcessor {
        @Override
        public List<Cell> preUpsert(byte[] tableName, List<Cell> keyValues) {
            return keyValues;
        }
    }

    @VisibleForTesting
    static class MapperUpsertListener<T>
    implements UpsertExecutor.UpsertListener<T> {
        private final Mapper.Context context;
        private final boolean ignoreRecordErrors;

        private MapperUpsertListener(Mapper.Context context, boolean ignoreRecordErrors) {
            this.context = context;
            this.ignoreRecordErrors = ignoreRecordErrors;
        }

        @Override
        public void upsertDone(long upsertCount) {
            this.context.getCounter(FormatToBytesWritableMapper.COUNTER_GROUP_NAME, "Upserts Done").increment(1L);
        }

        @Override
        public void errorOnRecord(T record, Throwable throwable) {
            LOGGER.error("Error on record " + record, throwable);
            this.context.getCounter(FormatToBytesWritableMapper.COUNTER_GROUP_NAME, "Errors on records").increment(1L);
            if (!this.ignoreRecordErrors) {
                Throwables.propagate((Throwable)throwable);
            }
        }
    }

    public static interface LineParser<T> {
        public T parse(String var1) throws IOException;
    }
}

