/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.log;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.log.LogLevel;
import org.apache.phoenix.log.QueryLogInfo;
import org.apache.phoenix.log.QueryLoggerDisruptor;
import org.apache.phoenix.log.RingBufferEventTranslator;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryLogger {
    private final ThreadLocal<RingBufferEventTranslator> threadLocalTranslator = new ThreadLocal();
    private QueryLoggerDisruptor queryDisruptor;
    private String queryId;
    private LogLevel logLevel;
    private ImmutableMap.Builder<QueryLogInfo, Object> queryLogBuilder = ImmutableMap.builder();
    private boolean isSynced;
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryLogger.class);
    public static final QueryLogger NO_OP_INSTANCE = new QueryLogger(){

        @Override
        public void log(QueryLogInfo queryLogInfo, Object info) {
        }

        @Override
        public boolean isDebugEnabled() {
            return false;
        }

        @Override
        public boolean isInfoEnabled() {
            return false;
        }

        @Override
        public void sync(Map<String, Map<MetricType, Long>> readMetrics, Map<MetricType, Long> overAllMetrics) {
        }

        @Override
        public boolean isSynced() {
            return true;
        }
    };

    protected QueryLogger(PhoenixConnection connection) {
        this.queryId = UUID.randomUUID().toString();
        this.queryDisruptor = connection.getQueryServices().getQueryDisruptor();
        this.logLevel = connection.getLogLevel();
        this.log(QueryLogInfo.QUERY_ID_I, this.queryId);
        this.log(QueryLogInfo.START_TIME_I, EnvironmentEdgeManager.currentTimeMillis());
    }

    protected QueryLogger() {
        this.logLevel = LogLevel.OFF;
    }

    private RingBufferEventTranslator getCachedTranslator() {
        RingBufferEventTranslator result = this.threadLocalTranslator.get();
        if (result == null) {
            result = new RingBufferEventTranslator(this.queryId);
            this.threadLocalTranslator.set(result);
        }
        return result;
    }

    public static QueryLogger getInstance(PhoenixConnection connection, boolean isSystemTable) {
        if (connection.getLogLevel() == LogLevel.OFF || isSystemTable || ThreadLocalRandom.current().nextDouble() > connection.getLogSamplingRate()) {
            return NO_OP_INSTANCE;
        }
        return new QueryLogger(connection);
    }

    public void log(QueryLogInfo queryLogInfo, Object info) {
        try {
            this.queryLogBuilder.put((Object)queryLogInfo, info);
        }
        catch (Exception e) {
            LOGGER.warn("Unable to add log info because of " + e.getMessage());
        }
    }

    private boolean publishLogs(RingBufferEventTranslator translator) {
        if (this.queryDisruptor == null) {
            return false;
        }
        boolean isLogged = this.queryDisruptor.tryPublish(translator);
        if (!isLogged && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Unable to write query log in table as ring buffer queue is full!!");
        }
        return isLogged;
    }

    public boolean isDebugEnabled() {
        return this.isLevelEnabled(LogLevel.DEBUG);
    }

    private boolean isLevelEnabled(LogLevel logLevel) {
        return this.logLevel != null && logLevel != LogLevel.OFF ? logLevel.ordinal() <= this.logLevel.ordinal() : false;
    }

    public boolean isInfoEnabled() {
        return this.isLevelEnabled(LogLevel.INFO);
    }

    public String getQueryId() {
        return this.queryId;
    }

    public void sync(Map<String, Map<MetricType, Long>> readMetrics, Map<MetricType, Long> overAllMetrics) {
        this.syncBase(readMetrics, overAllMetrics, this.logLevel);
    }

    public void syncBase(Map<String, Map<MetricType, Long>> readMetrics, Map<MetricType, Long> overAllMetrics, LogLevel logLevel) {
        if (!this.isSynced) {
            this.isSynced = true;
            RingBufferEventTranslator translator = this.getCachedTranslator();
            translator.setQueryInfo(logLevel, (ImmutableMap<QueryLogInfo, Object>)this.queryLogBuilder.build(), readMetrics, overAllMetrics);
            this.publishLogs(translator);
        }
    }

    public boolean isSynced() {
        return this.isSynced;
    }
}

