/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.log;

import java.util.Map;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.log.LogLevel;
import org.apache.phoenix.log.QueryLogInfo;
import org.apache.phoenix.log.QueryLogger;
import org.apache.phoenix.monitoring.MetricType;

public class AuditQueryLogger
extends QueryLogger {
    private LogLevel auditLogLevel;
    public static final AuditQueryLogger NO_OP_INSTANCE = new AuditQueryLogger(){

        @Override
        public void log(QueryLogInfo queryLogInfo, Object info) {
        }

        @Override
        public boolean isDebugEnabled() {
            return false;
        }

        @Override
        public boolean isInfoEnabled() {
            return false;
        }

        @Override
        public void sync(Map<String, Map<MetricType, Long>> readMetrics, Map<MetricType, Long> overAllMetrics) {
        }

        @Override
        public void syncAudit(Map<String, Map<MetricType, Long>> readMetrics, Map<MetricType, Long> overAllMetrics) {
        }

        @Override
        public boolean isSynced() {
            return true;
        }
    };

    private AuditQueryLogger(PhoenixConnection connection) {
        super(connection);
        this.auditLogLevel = connection.getAuditLogLevel();
    }

    private AuditQueryLogger() {
        this.auditLogLevel = LogLevel.OFF;
    }

    public static AuditQueryLogger getInstance(PhoenixConnection connection, boolean isSystemTable) {
        if (connection.getAuditLogLevel() == LogLevel.OFF || isSystemTable) {
            return NO_OP_INSTANCE;
        }
        return new AuditQueryLogger(connection);
    }

    public boolean isAuditLoggingEnabled() {
        return this.isAuditLevelEnabled(LogLevel.INFO);
    }

    private boolean isAuditLevelEnabled(LogLevel logLevel) {
        return this.auditLogLevel != null && logLevel != LogLevel.OFF ? logLevel.ordinal() <= this.auditLogLevel.ordinal() : false;
    }

    @Override
    public void sync(Map<String, Map<MetricType, Long>> readMetrics, Map<MetricType, Long> overAllMetrics) {
        this.syncBase(readMetrics, overAllMetrics, this.auditLogLevel);
    }

    public void syncAudit() {
        this.syncAudit(null, null);
    }

    public void syncAudit(Map<String, Map<MetricType, Long>> readMetrics, Map<MetricType, Long> overAllMetrics) {
        this.syncBase(readMetrics, overAllMetrics, LogLevel.TRACE);
    }
}

