/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.transaction.TransactionFactory;

@FunctionParseNode.BuiltInFunction(name="TransactionProviderName", args={@FunctionParseNode.Argument(allowedTypes={PInteger.class})})
public class TransactionProviderNameFunction
extends ScalarFunction {
    public static final String NAME = "TransactionProviderName";

    public TransactionProviderNameFunction() {
    }

    public TransactionProviderNameFunction(List<Expression> children) throws SQLException {
        super(children);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Expression child = (Expression)this.children.get(0);
        if (!child.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        byte code = PTinyint.INSTANCE.getCodec().decodeByte(ptr, child.getSortOrder());
        TransactionFactory.Provider provider = TransactionFactory.Provider.fromCode(code);
        ptr.set(PVarchar.INSTANCE.toBytes(provider.name()));
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PVarchar.INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

