/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.math.BigDecimal;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.aggregator.Aggregator;
import org.apache.phoenix.expression.aggregator.DecimalSumAggregator;
import org.apache.phoenix.expression.aggregator.DoubleSumAggregator;
import org.apache.phoenix.expression.aggregator.NumberSumAggregator;
import org.apache.phoenix.expression.function.CountAggregateFunction;
import org.apache.phoenix.expression.function.DelegateConstantToCountAggregateFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.SumAggregateParseNode;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PUnsignedDouble;
import org.apache.phoenix.schema.types.PUnsignedFloat;

@FunctionParseNode.BuiltInFunction(name="SUM", nodeClass=SumAggregateParseNode.class, args={@FunctionParseNode.Argument(allowedTypes={PDecimal.class})})
public class SumAggregateFunction
extends DelegateConstantToCountAggregateFunction {
    public static final String NAME = "SUM";

    public SumAggregateFunction() {
    }

    public SumAggregateFunction(List<Expression> childExpressions) {
        super(childExpressions, null);
    }

    public SumAggregateFunction(List<Expression> childExpressions, CountAggregateFunction delegate) {
        super(childExpressions, delegate);
    }

    private Aggregator newAggregator(final PDataType type, SortOrder sortOrder, ImmutableBytesWritable ptr) {
        if (type == PDecimal.INSTANCE) {
            return new DecimalSumAggregator(sortOrder, ptr);
        }
        if (PDataType.equalsAny(type, PUnsignedDouble.INSTANCE, PUnsignedFloat.INSTANCE, PDouble.INSTANCE, PFloat.INSTANCE)) {
            return new DoubleSumAggregator(sortOrder, ptr){

                @Override
                protected PDataType getInputDataType() {
                    return type;
                }
            };
        }
        return new NumberSumAggregator(sortOrder, ptr){

            @Override
            protected PDataType getInputDataType() {
                return type;
            }
        };
    }

    @Override
    public Aggregator newClientAggregator() {
        return this.newAggregator(this.getDataType(), SortOrder.getDefault(), null);
    }

    @Override
    public Aggregator newServerAggregator(Configuration conf) {
        Expression child = this.getAggregatorExpression();
        return this.newAggregator(child.getDataType(), child.getSortOrder(), null);
    }

    @Override
    public Aggregator newServerAggregator(Configuration conf, ImmutableBytesWritable ptr) {
        Expression child = this.getAggregatorExpression();
        return this.newAggregator(child.getDataType(), child.getSortOrder(), ptr);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (!super.evaluate(tuple, ptr)) {
            return false;
        }
        if (this.isConstantExpression()) {
            PDataType type = this.getDataType();
            Object constantValue = ((LiteralExpression)this.children.get(0)).getValue();
            if (type == PDecimal.INSTANCE) {
                BigDecimal value = ((BigDecimal)constantValue).multiply((BigDecimal)PDecimal.INSTANCE.toObject(ptr, (PDataType)PLong.INSTANCE));
                ptr.set(PDecimal.INSTANCE.toBytes(value));
            } else {
                long constantLongValue = ((Number)constantValue).longValue();
                long value = constantLongValue * type.getCodec().decodeLong(ptr, SortOrder.getDefault());
                byte[] resultPtr = new byte[type.getByteSize().intValue()];
                type.getCodec().encodeLong(value, resultPtr, 0);
                ptr.set(resultPtr);
            }
        }
        return true;
    }

    @Override
    public PDataType getDataType() {
        if (super.getDataType() == PDecimal.INSTANCE) {
            return PDecimal.INSTANCE;
        }
        if (PDataType.equalsAny(super.getDataType(), PUnsignedFloat.INSTANCE, PUnsignedDouble.INSTANCE, PFloat.INSTANCE, PDouble.INSTANCE)) {
            return PDouble.INSTANCE;
        }
        return PLong.INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

