/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.List;
import org.apache.phoenix.expression.BaseCompoundExpression;
import org.apache.phoenix.expression.Expression;

public abstract class FunctionExpression
extends BaseCompoundExpression {
    public FunctionExpression() {
    }

    public FunctionExpression(List<Expression> children) {
        super(children);
    }

    public OrderPreserving preservesOrder() {
        return OrderPreserving.NO;
    }

    public abstract String getName();

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(this.getName() + "(");
        if (this.children.size() == 0) {
            return buf.append(")").toString();
        }
        for (int i = 0; i < this.children.size() - 1; ++i) {
            buf.append(this.children.get(i) + ", ");
        }
        buf.append(this.children.get(this.children.size() - 1) + ")");
        return buf.toString();
    }

    public static enum OrderPreserving {
        NO,
        YES_IF_LAST,
        YES;


        public OrderPreserving combine(OrderPreserving that) {
            if (that == null) {
                return this;
            }
            return OrderPreserving.values()[Math.min(this.ordinal(), that.ordinal())];
        }
    }
}

